<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener auxiliar
$auxiliar = query("SELECT a.*, u.usuario, u.ultimo_acceso, u.fecha_registro as fecha_registro_usuario,
                        t.nombre as turno, t.abreviatura as turno_abrev, t.hora_ingreso, t.hora_salida
                 FROM auxiliares a
                 LEFT JOIN usuarios u ON a.id_usuario = u.id
                 LEFT JOIN turnos t ON t.id = a.id_turno
                 WHERE a.id = :id", ['id' => $id])->fetch();

if (!$auxiliar) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Ver Auxiliar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <nav class="sidebar">
        <?php include '../includes/sidebar.php'; ?>
    </nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Detalle del Auxiliar</h3>
                <p class="text-muted mb-0">Información completa del auxiliar</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Volver
            </a>
        </div>

        <div class="row">
            <!-- Información Personal -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-person-badge"></i> Información Personal</h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <div class="avatar-circle avatar-lg mb-2">
                                <?= substr($auxiliar['nombres'], 0, 1) . substr($auxiliar['apellido_paterno'], 0, 1) ?>
                            </div>
                            <h4><?= htmlspecialchars($auxiliar['apellido_paterno'] . ' ' . $auxiliar['apellido_materno'] . ', ' . $auxiliar['nombres']) ?></h4>
                            <p class="text-muted mb-0">@<?= htmlspecialchars($auxiliar['usuario']) ?></p>
                        </div>

                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>DNI:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['dni']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Paterno:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['apellido_paterno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Materno:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['apellido_materno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Nombres:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['nombres']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Género:</strong></td>
                                <td><?= $auxiliar['genero'] === 'M' ? 'Masculino' : 'Femenino' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Nacimiento:</strong></td>
                                <td><?= $auxiliar['fecha_nacimiento'] ? date('d/m/Y', strtotime($auxiliar['fecha_nacimiento'])) : '-' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['email'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Teléfono:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['telefono'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Dirección:</strong></td>
                                <td><?= htmlspecialchars($auxiliar['direccion'] ?: '-') ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Información del Sistema -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-info-circle"></i> Información del Sistema</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Usuario:</strong></td>
                                <td>
                                    <code><?= htmlspecialchars($auxiliar['usuario']) ?></code>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Rol:</strong></td>
                                <td><span class="badge bg-info">Auxiliar</span></td>
                            </tr>
                            <tr>
                                <td><strong>Estado Auxiliar:</strong></td>
                                <td>
                                    <?php
                                    $badge_class = match($auxiliar['estado']) {
                                        'activo' => 'bg-success',
                                        'inactivo' => 'bg-secondary',
                                        'retirado' => 'bg-warning',
                                        default => 'bg-secondary'
                                    };
                                    ?>
                                    <span class="badge <?= $badge_class ?>">
                                        <?= ucfirst($auxiliar['estado']) ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Registro:</strong></td>
                                <td><?= date('d/m/Y H:i', strtotime($auxiliar['fecha_registro_usuario'])) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Último Acceso:</strong></td>
                                <td>
                                    <?php if ($auxiliar['ultimo_acceso']): ?>
                                        <?= date('d/m/Y H:i', strtotime($auxiliar['ultimo_acceso'])) ?>
                                    <?php else: ?>
                                        <span class="text-muted">Sin accesos</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>

                        <hr>

                        <div class="d-grid gap-2">
                            <a href="editar.php?id=<?= $auxiliar['id'] ?>" class="btn btn-primary">
                                <i class="bi bi-pencil"></i> Editar Información
                            </a>
                            <a href="../perfil.php" class="btn btn-outline-primary">
                                <i class="bi bi-key"></i> Cambiar Contraseña
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Acciones -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex gap-2">
                    <a href="editar.php?id=<?= $auxiliar['id'] ?>" class="btn btn-primary">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                    <a href="index.php" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Volver al Listado
                    </a>
                    <a href="eliminar.php?id=<?= $auxiliar['id'] ?>" class="btn btn-outline-danger ms-auto"
                        onclick="return confirm('¿Está seguro de eliminar este auxiliar?')">
                        <i class="bi bi-trash"></i> Eliminar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
