<?php
require_once 'db.php';
require_once 'functions.php';

header('Content-Type: application/json');

$action = $_GET['action'] ?? $_POST['action'] ?? '';

if ($action === 'get_grados') {
    $id_nivel = $_GET['id_nivel'] ?? '';
    if (!$id_nivel) {
        echo json_encode([]);
        exit;
    }

    $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

    $grados = query("SELECT DISTINCT grado FROM secciones WHERE id_nivel = ? AND id_anio_lectivo = ? ORDER BY grado",
        [$id_nivel, $anio_activo['id']])->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode($grados);

} elseif ($action === 'get_grados_by_id') {
    $id_nivel = $_GET['id_nivel'] ?? '';
    if (!$id_nivel) {
        echo json_encode([]);
        exit;
    }

    $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

    $grados = query("SELECT id, grado FROM grados WHERE id_nivel = ? AND id_anio_lectivo = ? AND estado = 'activo' ORDER BY grado",
        [$id_nivel, $anio_activo['id']])->fetchAll();

    echo json_encode($grados);

} elseif ($action === 'get_areas_by_nivel') {
    $id_nivel = $_GET['id_nivel'] ?? '';
    if (!$id_nivel) {
        echo json_encode([]);
        exit;
    }

    $anio_seleccionado = getAnioLectivoSeleccionado();

    $areas = query("SELECT id, area FROM areas_academicas
                   WHERE id_nivel = ? AND id_anio_lectivo = ? AND estado = 'activo'
                   ORDER BY area",
        [$id_nivel, $anio_seleccionado])->fetchAll();

    echo json_encode($areas);

} elseif ($action === 'get_secciones') {
    $id_nivel = $_GET['id_nivel'] ?? '';
    $grado = $_GET['grado'] ?? '';

    if (!$id_nivel || !$grado) {
        echo json_encode([]);
        exit;
    }

    $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

    $secciones = query("SELECT id, seccion FROM secciones WHERE id_nivel = ? AND grado = ? AND id_anio_lectivo = ? ORDER BY seccion",
        [$id_nivel, $grado, $anio_activo['id']])->fetchAll();

    echo json_encode($secciones);

} elseif ($action === 'buscar_estudiante') {
    // Deshabilitar visualización de errores
    ini_set('display_errors', 0);
    error_reporting(0);

    try {
        // Verificar rol sin usar requerirRol que hace die()
        if (!isset($_SESSION['usuario_rol']) || !in_array($_SESSION['usuario_rol'], ['admin', 'auxiliar'])) {
            echo json_encode(['success' => false, 'mensaje' => 'No tienes permisos para realizar esta acción']);
            exit;
        }

        $dni = $_GET['dni'] ?? '';

        if (strlen($dni) < 8) {
            echo json_encode(['success' => false, 'mensaje' => 'DNI incompleto']);
            exit;
        }

        $anio_seleccionado_id = getAnioLectivoSeleccionado();

        if (!$anio_seleccionado_id) {
            echo json_encode(['success' => false, 'mensaje' => 'No hay año lectivo seleccionado']);
            exit;
        }

        $estudiante = query("SELECT e.id, e.dni, e.apellido_paterno, e.apellido_materno, e.nombres,
                            g.grado, s.seccion, n.nombre AS nivel, t.nombre AS turno, ea.id AS id_apoderado
                            FROM estudiantes e
                            INNER JOIN programaciones_estudiantes pe ON e.id = pe.id_estudiante
                            INNER JOIN programaciones p ON pe.id_programacion = p.id
                            INNER JOIN turnos t ON p.id_turno = t.id
                            INNER JOIN secciones s ON p.id_seccion = s.id
                            INNER JOIN grados g ON s.id_grado = g.id
                            INNER JOIN niveles n ON g.id_nivel = n.id
                            LEFT JOIN estudiantes_apoderados sea ON e.id = sea.id_estudiante AND sea.id_anio_lectivo = ?
                            LEFT JOIN apoderados ea ON sea.id_apoderado = ea.id
                            WHERE e.dni = ? AND p.id_anio_lectivo = ? AND pe.estado = 'activo'
                            AND e.estado = 'activo' AND p.estado = 'activo'
                            LIMIT 1",
            [$anio_seleccionado_id, $dni, $anio_seleccionado_id])->fetch();

        if ($estudiante) {
            echo json_encode(['success' => true, 'estudiante' => $estudiante]);
        } else {
            echo json_encode(['success' => false, 'mensaje' => 'Estudiante no encontrado o sin programación activa']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'mensaje' => 'Error: ' . $e->getMessage()]);
    }

} elseif ($action === 'registrar_asistencia_manual') {
    // Deshabilitar visualización de errores
    ini_set('display_errors', 0);
    error_reporting(0);

    try {
        // Verificar rol sin usar requerirRol que hace die()
        if (!isset($_SESSION['usuario_rol']) || !in_array($_SESSION['usuario_rol'], ['admin', 'auxiliar'])) {
            echo json_encode(['success' => false, 'mensaje' => 'No tienes permisos para realizar esta acción']);
            exit;
        }

    $dni = $_POST['dni'] ?? '';
    $id_estado_asistencia = $_POST['id_estado_asistencia'] ?? '';
    $fecha_registro = $_POST['fecha_registro'] ?? date('Y-m-d');
    $hora_registro = $_POST['hora_registro'] ?? date('H:i:s');
    $observaciones = $_POST['observaciones'] ?? '';

    if (!$dni || !$id_estado_asistencia || !$fecha_registro) {
        echo json_encode(['success' => false, 'mensaje' => 'Datos incompletos']);
        exit;
    }

    // VALIDACIÓN 1: Verificar año lectivo seleccionado
    $anio_seleccionado_id = getAnioLectivoSeleccionado();

    if (!$anio_seleccionado_id) {
        echo json_encode(['success' => false, 'mensaje' => 'No hay año lectivo seleccionado']);
        exit;
    }

    $anio_seleccionado = query("SELECT id, anio, fecha_inicio, fecha_fin FROM anios_lectivos WHERE id = ? LIMIT 1", [$anio_seleccionado_id])->fetch();

    if (!$anio_seleccionado) {
        echo json_encode(['success' => false, 'mensaje' => 'Año lectivo seleccionado no encontrado']);
        exit;
    }

    // VALIDACIÓN 2: Verificar si la fecha seleccionada está fuera del rango del año lectivo (vacaciones)
    if ($fecha_registro < $anio_seleccionado['fecha_inicio'] || $fecha_registro > $anio_seleccionado['fecha_fin']) {
        if ($fecha_registro < $anio_seleccionado['fecha_inicio']) {
            $mensaje = "La fecha seleccionada está antes del inicio del año lectivo {$anio_seleccionado['anio']}. ";
            $mensaje .= "Inicio de clases: " . date('d/m/Y', strtotime($anio_seleccionado['fecha_inicio']));
        } else {
            $mensaje = "La fecha seleccionada está después del fin del año lectivo {$anio_seleccionado['anio']}. ";
            $mensaje .= "Fin de clases: " . date('d/m/Y', strtotime($anio_seleccionado['fecha_fin']));
        }

        echo json_encode([
            'success' => false,
            'mensaje' => $mensaje,
            'es_dia_calendario' => true,
            'calendario_info' => [
                'tipo' => 'vacacion',
                'nombre' => 'Vacaciones por año lectivo',
                'afecta_todos_niveles' => true
            ]
        ]);
        exit;
    }

    // VALIDACIÓN 3: Verificar si la fecha seleccionada es un día no laborable (feriado, vacación programada, etc.)
    try {
        $dia_calendario = query("SELECT * FROM calendario
                                WHERE (fecha = ? AND estado = 'activo')
                                AND (aniolectivo_id IS NULL OR aniolectivo_id = ?)
                                LIMIT 1",
            [$fecha_registro, $anio_seleccionado_id])->fetch();

        if ($dia_calendario) {
            $tipo_label = match($dia_calendario['tipo']) {
                'feriado' => 'Feriado',
                'vacacion' => 'Vacación',
                'dia_no_laboral' => 'Día No Laboral',
                'fin_semana_largo' => 'Fin de Semana Largo',
                default => $dia_calendario['tipo']
            };

            $mensaje = "La fecha seleccionada es {$tipo_label}: {$dia_calendario['nombre']}. ";

            if ($dia_calendario['afecta_todos_niveles']) {
                $mensaje .= "No se registran asistencias este día.";
            } else {
                $mensaje .= "Verificar si afecta al nivel del estudiante.";
            }

            echo json_encode([
                'success' => false,
                'mensaje' => $mensaje,
                'es_dia_calendario' => true,
                'calendario_info' => [
                    'tipo' => $dia_calendario['tipo'],
                    'nombre' => $dia_calendario['nombre'],
                    'afecta_todos_niveles' => $dia_calendario['afecta_todos_niveles']
                ]
            ]);
            exit;
        }
    } catch (Exception $e) {
        // Si la tabla calendario no existe, continuar sin validación
    }

    // VALIDACIÓN 4: Verificar si ya está registrado en esa fecha
    $ya_registrado = query("SELECT id FROM asistencias
                            WHERE id_estudiante IN (SELECT id FROM estudiantes WHERE dni = ?)
                            AND fecha = ?",
        [$dni, $fecha_registro])->fetch();

    if ($ya_registrado) {
        echo json_encode(['success' => false, 'mensaje' => 'El estudiante ya tiene asistencia registrada en esa fecha']);
        exit;
    }

    // VALIDACIÓN 5: Buscar estudiante con su programación activa
    $estudiante = query("SELECT e.id, e.dni, e.apellido_paterno, e.apellido_materno, e.nombres,
                        pe.id_programacion, p.id_turno, g.grado, s.seccion, n.nombre AS nivel
                        FROM estudiantes e
                        INNER JOIN programaciones_estudiantes pe ON e.id = pe.id_estudiante
                        INNER JOIN programaciones p ON pe.id_programacion = p.id
                        INNER JOIN turnos t ON p.id_turno = t.id
                        INNER JOIN secciones s ON p.id_seccion = s.id
                        INNER JOIN grados g ON s.id_grado = g.id
                        INNER JOIN niveles n ON g.id_nivel = n.id
                        WHERE e.dni = ? AND p.id_anio_lectivo = ? AND pe.estado = 'activo'
                        AND e.estado = 'activo' AND p.estado = 'activo'
                        LIMIT 1",
        [$dni, $anio_seleccionado_id])->fetch();

    if (!$estudiante) {
        echo json_encode(['success' => false, 'mensaje' => 'Estudiante no encontrado o sin programación activa']);
        exit;
    }

    // VALIDACIÓN 6: Obtener información del estado de asistencia
    $estado_info = query("SELECT nombre, abreviatura, color, icono FROM estados_asistencia WHERE id = ?", [$id_estado_asistencia])->fetch();

    if (!$estado_info) {
        echo json_encode(['success' => false, 'mensaje' => 'Estado de asistencia no válido']);
        exit;
    }

    // Registrar asistencia manual en la tabla asistencias
    $resultado = query("INSERT INTO asistencias (id_estudiante, id_anio_lectivo, id_programacion, id_turno, id_estado_asistencia,
                                   fecha, hora_registro, estado_codigo, observaciones, registrado_por, metodo_registro)
           VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'manual')",
        [$estudiante['id'], $anio_seleccionado_id, $estudiante['id_programacion'], $estudiante['id_turno'],
         $id_estado_asistencia, $fecha_registro, $hora_registro, $estado_info['nombre'], $observaciones, $_SESSION['usuario']]);

    // Verificar si el INSERT fue exitoso
    if (!$resultado) {
        echo json_encode(['success' => false, 'mensaje' => 'Error al registrar asistencia en la base de datos']);
        exit;
    }

    echo json_encode([
        'success' => true,
        'mensaje' => 'Asistencia registrada correctamente',
        'estudiante' => [
            'nombre' => $estudiante['apellido_paterno'] . ' ' . $estudiante['apellido_materno'] . ', ' . $estudiante['nombres'],
            'dni' => $estudiante['dni'],
            'grado' => $estudiante['grado'],
            'seccion' => $estudiante['seccion'],
            'nivel' => $estudiante['nivel'],
            'fecha' => date('d/m/Y', strtotime($fecha_registro)),
            'hora' => $hora_registro,
            'estado_nombre' => $estado_info['nombre'],
            'estado_abreviatura' => $estado_info['abreviatura'],
            'estado_color' => $estado_info['color'],
            'estado_icono' => $estado_info['icono']
        ]
    ]);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'mensaje' => 'Error: ' . $e->getMessage()]);
    }

} elseif ($action === 'registrar_asistencia') {
    // Verificar rol sin usar requerirRol que hace die()
    if (!isset($_SESSION['usuario_rol']) || !in_array($_SESSION['usuario_rol'], ['admin', 'auxiliar'])) {
        echo json_encode(['success' => false, 'mensaje' => 'No tienes permisos para realizar esta acción']);
        exit;
    }

    $dni = $_POST['dni'] ?? '';
    $metodo = $_POST['metodo'] ?? 'qr';

    if (!$dni) {
        echo json_encode(['success' => false, 'mensaje' => 'DNI requerido']);
        exit;
    }

    $anio_seleccionado_id = getAnioLectivoSeleccionado();

    if (!$anio_seleccionado_id) {
        echo json_encode(['success' => false, 'mensaje' => 'No hay año lectivo seleccionado']);
        exit;
    }

    $anio_seleccionado = query("SELECT id, anio, fecha_inicio, fecha_fin FROM anios_lectivos WHERE id = ? LIMIT 1", [$anio_seleccionado_id])->fetch();

    if (!$anio_seleccionado) {
        echo json_encode(['success' => false, 'mensaje' => 'Año lectivo seleccionado no encontrado']);
        exit;
    }

    $hoy = date('Y-m-d');
    $hora_actual = date('H:i:s');

    // ============================================
    // VALIDACIÓN 1: Verificar si hoy es vacaciones del año lectivo
    // ============================================
    // En Perú, los estudiantes están de vacaciones cuando la fecha actual
    // está fuera del rango fecha_inicio - fecha_fin del año lectivo seleccionado
    $fecha_inicio = $anio_seleccionado['fecha_inicio'];
    $fecha_fin = $anio_seleccionado['fecha_fin'];

    // Si hoy está ANTES del inicio o DESPUÉS del fin del año lectivo → vacaciones
    if ($hoy < $fecha_inicio || $hoy > $fecha_fin) {
        echo json_encode([
            'success' => false,
            'mensaje' => $mensaje,
            'es_dia_calendario' => true,
            'calendario_info' => [
                'tipo' => 'vacacion',
                'nombre' => 'Vacaciones por año lectivo',
                'afecta_todos_niveles' => true
            ]
        ]);
        exit;
    }

    // ============================================
    // VALIDACIÓN 2: Verificar si hoy es un día no laborable (feriado, vacación programada, etc.)
    // ============================================
    // Busca en calendario GLOBAL (aniolectivo_id IS NULL) o específico del año seleccionado
    try {
        $dia_calendario = query("SELECT * FROM calendario
                                WHERE (fecha = ? AND estado = 'activo')
                                AND (aniolectivo_id IS NULL OR aniolectivo_id = ?)
                                LIMIT 1",
            [$hoy, $anio_seleccionado_id])->fetch();

        if ($dia_calendario) {
            $tipo_label = match($dia_calendario['tipo']) {
                'feriado' => 'Feriado',
                'vacacion' => 'Vacación',
                'dia_no_laboral' => 'Día No Laboral',
                'fin_semana_largo' => 'Fin de Semana Largo',
                default => $dia_calendario['tipo']
            };

            $mensaje = "Hoy es {$tipo_label}: {$dia_calendario['nombre']}. ";

            if ($dia_calendario['afecta_todos_niveles']) {
                $mensaje .= "No se registran asistencias.";
            } else {
                $mensaje .= "Verificar si afecta al nivel del estudiante.";
            }

            echo json_encode([
                'success' => false,
                'mensaje' => $mensaje,
                'es_dia_calendario' => true,
                'calendario_info' => [
                    'tipo' => $dia_calendario['tipo'],
                    'nombre' => $dia_calendario['nombre'],
                    'afecta_todos_niveles' => $dia_calendario['afecta_todos_niveles']
                ]
            ]);
            exit;
        }
    } catch (Exception $e) {
        // Si la tabla calendario no existe, continuar sin validación
    }

    // Buscar estudiante primero (para mostrar datos en caso de duplicado)
    $estudiante = query("SELECT e.id, e.dni, e.apellido_paterno, e.apellido_materno, e.nombres,
                        pe.id_programacion,
                        p.id_turno,
                        t.nombre AS turno_nombre,
                        t.abreviatura AS turno_abreviatura,
                        t.hora_ingreso,
                        t.tolerancia_minutos,
                        g.grado,
                        s.seccion,
                        n.nombre AS nivel
                        FROM estudiantes e
                        INNER JOIN programaciones_estudiantes pe ON e.id = pe.id_estudiante
                        INNER JOIN programaciones p ON pe.id_programacion = p.id
                        INNER JOIN turnos t ON p.id_turno = t.id
                        INNER JOIN secciones s ON p.id_seccion = s.id
                        INNER JOIN grados g ON s.id_grado = g.id
                        INNER JOIN niveles n ON g.id_nivel = n.id
                        WHERE e.dni = ?
                        AND p.id_anio_lectivo = ?
                        AND pe.estado = 'activo'
                        AND e.estado = 'activo'
                        AND p.estado = 'activo'
                        LIMIT 1",
        [$dni, $anio_seleccionado_id])->fetch();

    if (!$estudiante) {
        echo json_encode(['success' => false, 'mensaje' => 'Estudiante no encontrado o sin programación activa']);
        exit;
    }

    // Verificar si ya está registrado hoy
    $ya_registrado = query("SELECT id FROM asistencias
                            WHERE id_estudiante IN (SELECT id FROM estudiantes WHERE dni = ?)
                            AND fecha = ?",
        [$dni, $hoy])->fetch();

    if ($ya_registrado) {
        $nombre_completo = $estudiante['apellido_paterno'] . ' ' . $estudiante['apellido_materno'] . ', ' . $estudiante['nombres'];
        echo json_encode([
            'success' => false,
            'mensaje' => 'El estudiante ya tiene asistencia registrada hoy',
            'estudiante' => [
                'dni' => $estudiante['dni'],
                'nombre' => $nombre_completo,
                'grado' => $estudiante['grado'],
                'seccion' => $estudiante['seccion']
            ]
        ]);
        exit;
    }

    // Determinar estado de asistencia según hora
    $estado_codigo = 'Asistencia';
    $minutos_tardanza = 0;
    $id_estado_asistencia = null;

    if ($estudiante['hora_ingreso']) {
        $hora_ingreso = strtotime($estudiante['hora_ingreso']);
        $hora_actual_ts = strtotime($hora_actual);
        $tolerancia = $estudiante['tolerancia_minutos'] ?? 15;
        $limite_tolerancia = $hora_ingreso + ($tolerancia * 60);

        if ($hora_actual_ts > $limite_tolerancia) {
            // Hay tardanza
            $minutos_tardanza = round(($hora_actual_ts - $hora_ingreso) / 60);
            $estado_codigo = 'Tardanza';
        }
    }

    // Obtener ID del estado de asistencia
    $estado_asist = query("SELECT id, nombre, abreviatura, color, icono, permite_tardanza
                          FROM estados_asistencia
                          WHERE nombre = ? AND estado = 'activo'
                          LIMIT 1",
        [$estado_codigo])->fetch();

    if (!$estado_asist) {
        // Fallback a Asistencia si no se encuentra el estado
        $estado_asist = query("SELECT id, nombre, abreviatura, color, icono, permite_tardanza
                              FROM estados_asistencia
                              WHERE nombre = 'Asistencia' AND estado = 'activo'
                              LIMIT 1")->fetch();
    }

    if (!$estado_asist) {
        echo json_encode(['success' => false, 'mensaje' => 'No se encontraron estados de asistencia configurados']);
        exit;
    }

    $id_estado_asistencia = $estado_asist['id'];

    // Verificar si el estado permite tardanza
    if ($minutos_tardanza > 0 && !$estado_asist['permite_tardanza']) {
        // Si el estado no permite tardanza, buscar uno que sí permita
        $estado_tardanza = query("SELECT id, nombre, abreviatura, color, icono
                                 FROM estados_asistencia
                                 WHERE nombre LIKE '%Tardanza%' AND estado = 'activo'
                                 AND permite_tardanza = TRUE
                                 LIMIT 1")->fetch();

        if ($estado_tardanza) {
            $id_estado_asistencia = $estado_tardanza['id'];
            $estado_asist = $estado_tardanza;
        }
    }

    // Registrar asistencia
    $sql = "INSERT INTO asistencias (id_estudiante, id_anio_lectivo, id_programacion, id_turno, id_estado_asistencia,
                                     fecha, hora_registro, estado_codigo, minutos_tardanza, registrado_por, metodo_registro)
            VALUES (:id_estudiante, :id_anio_lectivo, :id_programacion, :id_turno, :id_estado_asistencia,
                    :fecha, :hora_registro, :estado_codigo, :minutos_tardanza, :registrado_por, :metodo_registro)";

    $params = [
        'id_estudiante' => $estudiante['id'],
        'id_anio_lectivo' => $anio_seleccionado_id,
        'id_programacion' => $estudiante['id_programacion'],
        'id_turno' => $estudiante['id_turno'],
        'id_estado_asistencia' => $id_estado_asistencia,
        'fecha' => $hoy,
        'hora_registro' => $hora_actual,
        'estado_codigo' => $estado_asist['nombre'],
        'minutos_tardanza' => $minutos_tardanza,
        'registrado_por' => $_SESSION['usuario'],
        'metodo_registro' => $metodo
    ];

    if (query($sql, $params)) {
        $mensaje = $minutos_tardanza > 0
            ? "{$estado_asist['nombre']} registrada ({$minutos_tardanza} min)"
            : "{$estado_asist['nombre']} registrada correctamente";

        $nombre_completo = $estudiante['apellido_paterno'] . ' ' . $estudiante['apellido_materno'] . ', ' . $estudiante['nombres'];
        $grado_seccion = "{$estudiante['grado']} \"{$estudiante['seccion']}\"";

        echo json_encode([
            'success' => true,
            'mensaje' => $mensaje,
            'estudiante' => [
                'dni' => $estudiante['dni'],
                'nombre' => $nombre_completo,
                'grado' => $estudiante['grado'],
                'seccion' => $estudiante['seccion'],
                'hora' => $hora_actual,
                'estado' => $minutos_tardanza > 0 ? 'tarde' : 'asistente',
                'minutos_tardanza' => $minutos_tardanza,
                'estado_nombre' => $estado_asist['nombre'],
                'estado_abreviatura' => $estado_asist['abreviatura'],
                'estado_color' => $estado_asist['color'],
                'estado_icono' => $estado_asist['icono']
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'mensaje' => 'Error al registrar asistencia']);
    }

} else {
    echo json_encode(['success' => false, 'mensaje' => 'Acción no válida: ' . $action]);
}
