<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';
    $id_nivel = $_POST['id_nivel'] ?? '';
    $grado = sanitizar($_POST['grado'] ?? '');

    if ($accion === 'crear') {
        if (empty($id_nivel) || empty($grado)) {
            $errores[] = 'Complete todos los campos';
        } else {
            $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();
            $existe = query("SELECT id FROM grados WHERE id_nivel = ? AND LOWER(grado) = LOWER(?) AND id_anio_lectivo = ?", [$id_nivel, $grado, $anio_activo['id']])->fetch();
            if ($existe) {
                $errores[] = 'El grado ya existe en este nivel';
            } else {
                query("INSERT INTO grados (id_nivel, id_anio_lectivo, grado) VALUES (?, ?, ?)", [$id_nivel, $anio_activo['id'], $grado]);
                setAlerta('success', 'Grado creado correctamente');
            }
        }
    } elseif ($accion === 'editar') {
        $id = $_POST['id'] ?? '';
        if (empty($id_nivel) || empty($grado)) {
            $errores[] = 'Complete todos los campos';
        } else {
            $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();
            $existe = query("SELECT id FROM grados WHERE id_nivel = ? AND LOWER(grado) = LOWER(?) AND id_anio_lectivo = ? AND id != ?", [$id_nivel, $grado, $anio_activo['id'], $id])->fetch();
            if ($existe) {
                $errores[] = 'El grado ya existe en este nivel';
            } else {
                query("UPDATE grados SET id_nivel = ?, grado = ? WHERE id = ?", [$id_nivel, $grado, $id]);
                setAlerta('success', 'Grado actualizado correctamente');
            }
        }
    } elseif ($accion === 'eliminar') {
        $id = $_POST['id'] ?? '';
        $tiene_secciones = query("SELECT COUNT(*) FROM secciones WHERE id_grado = ?", [$id])->fetchColumn();
        if ($tiene_secciones > 0) {
            $errores[] = 'No se puede eliminar: tiene secciones asociadas';
        } else {
            query("DELETE FROM grados WHERE id = ?", [$id]);
            setAlerta('success', 'Grado eliminado');
        }
    }

    if (empty($errores)) {
        header('Location: grados.php');
        exit;
    }
}

// Verificar si estamos editando
$modo_edicion = false;
$grado_editar = null;
if (isset($_GET['editar'])) {
    $id_editar = (int)$_GET['editar'];
    $grado_editar = query("SELECT * FROM grados WHERE id = ?", [$id_editar])->fetch();
    if ($grado_editar) {
        $modo_edicion = true;
    }
}

$niveles = query("SELECT * FROM niveles WHERE estado = 'activo'")->fetchAll();
$anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

// Obtener todos los grados
$grados = query("SELECT g.*, n.nombre AS nivel FROM grados g LEFT JOIN niveles n ON g.id_nivel = n.id WHERE g.id_anio_lectivo = ? ORDER BY n.nombre, g.grado", [$anio_activo['id']])->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Grados</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .content-card { background: white; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); padding: 25px; }
    </style>
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div><h3 class="mb-1">Grados</h3><p class="text-muted mb-0">Gestión de grados por nivel educativo</p></div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger"><?php foreach ($errores as $e) echo "$e<br>"; ?></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card">
                    <h5 class="mb-3"><?= $modo_edicion ? 'Editar Grado' : 'Nuevo Grado' ?></h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="<?= $modo_edicion ? 'editar' : 'crear' ?>">
                        <?php if ($modo_edicion): ?>
                            <input type="hidden" name="id" value="<?= $grado_editar['id'] ?>">
                        <?php endif; ?>
                        <div class="mb-3">
                            <label class="form-label">Nivel <span class="text-danger">*</span></label>
                            <select name="id_nivel" class="form-select" required>
                                <option value="">Seleccione</option>
                                <?php foreach ($niveles as $n): ?>
                                    <option value="<?= $n['id'] ?>" <?= $modo_edicion && $grado_editar['id_nivel'] == $n['id'] ? 'selected' : '' ?>><?= $n['nombre'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Grado <span class="text-danger">*</span></label>
                            <input type="text" name="grado" class="form-control" placeholder="Ej: 1°, 2°, 3°, 3 años, 4 años, etc."
                                   value="<?= $modo_edicion ? htmlspecialchars($grado_editar['grado']) : '' ?>" required>
                        </div>
                        <?php if ($modo_edicion): ?>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary flex-fill"><i class="bi bi-save me-2"></i>Guardar</button>
                                <a href="grados.php" class="btn btn-secondary">Cancelar</a>
                            </div>
                        <?php else: ?>
                            <button type="submit" class="btn btn-primary w-100"><i class="bi bi-plus-circle me-2"></i>Crear</button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card">
                    <h5 class="mb-3">Grados Registrados</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nivel</th>
                                    <th>Grado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($grados as $g): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= htmlspecialchars($g['nivel']) ?></span></td>
                                    <td><strong><?= htmlspecialchars($g['grado']) ?></strong></td>
                                    <td>
                                        <a href="grados.php?editar=<?= $g['id'] ?>" class="btn btn-sm btn-primary" title="Editar"><i class="bi bi-pencil"></i></a>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar grado?')">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <input type="hidden" name="id" value="<?= $g['id'] ?>">
                                            <button class="btn btn-sm btn-danger" title="Eliminar"><i class="bi bi-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
