<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';
    $nombre = sanitizar($_POST['nombre'] ?? '');
    $id = $_POST['id'] ?? '';
    $estado = $_POST['estado'] ?? 'activo';

    if ($accion === 'crear') {
        if (empty($nombre)) $errores[] = 'El nombre es obligatorio';
        else {
            $existe = query("SELECT id FROM niveles WHERE LOWER(nombre) = LOWER(?)", [$nombre])->fetch();
            if ($existe) $errores[] = 'El nivel ya existe';
            else {
                query("INSERT INTO niveles (nombre, estado) VALUES (?, 'activo')", [$nombre]);
                setAlerta('success', 'Nivel creado correctamente');
            }
        }
    } elseif ($accion === 'editar') {
        if (empty($nombre)) $errores[] = 'El nombre es obligatorio';
        else {
            $existe = query("SELECT id FROM niveles WHERE LOWER(nombre) = LOWER(?) AND id != ?", [$nombre, $id])->fetch();
            if ($existe) $errores[] = 'El nivel ya existe';
            else {
                query("UPDATE niveles SET nombre = ?, estado = ? WHERE id = ?", [$nombre, $estado, $id]);
                setAlerta('success', 'Nivel actualizado correctamente');
            }
        }
    } elseif ($accion === 'toggle_estado') {
        $actual = query("SELECT estado FROM niveles WHERE id = ?", [$id])->fetch();
        $nuevo_estado = $actual['estado'] === 'activo' ? 'inactivo' : 'activo';
        query("UPDATE niveles SET estado = ? WHERE id = ?", [$nuevo_estado, $id]);
        setAlerta('success', 'Estado actualizado');
    } elseif ($accion === 'eliminar') {
        $tiene_datos = query("SELECT COUNT(*) FROM secciones WHERE id_nivel = ?", [$id])->fetchColumn();
        if ($tiene_datos > 0) $errores[] = 'No se puede eliminar: tiene secciones asociadas';
        else {
            query("DELETE FROM niveles WHERE id = ?", [$id]);
            setAlerta('success', 'Nivel eliminado');
        }
    }

    if (empty($errores)) {
        header('Location: niveles.php');
        exit;
    }
}

// Verificar si estamos editando
$modo_edicion = false;
$nivel_editar = null;
if (isset($_GET['editar'])) {
    $id_editar = (int)$_GET['editar'];
    $nivel_editar = query("SELECT * FROM niveles WHERE id = ?", [$id_editar])->fetch();
    if ($nivel_editar) {
        $modo_edicion = true;
    }
}

$niveles = query("SELECT * FROM niveles ORDER BY nombre")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Niveles Educativos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .content-card { background: white; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); padding: 25px; }
    </style>
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Niveles Educativos</h3>
                <p class="text-muted mb-0">Gestión de niveles: Inicial, Primaria, Secundaria</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger"><?php foreach ($errores as $e) echo "$e<br>"; ?></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card">
                    <h5 class="mb-3"><?= $modo_edicion ? 'Editar Nivel' : 'Nuevo Nivel' ?></h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="<?= $modo_edicion ? 'editar' : 'crear' ?>">
                        <?php if ($modo_edicion): ?>
                            <input type="hidden" name="id" value="<?= $nivel_editar['id'] ?>">
                        <?php endif; ?>
                        <div class="mb-3">
                            <label class="form-label">Nombre <span class="text-danger">*</span></label>
                            <input type="text" name="nombre" class="form-control" placeholder="Ej: Inicial"
                                   value="<?= $modo_edicion ? htmlspecialchars($nivel_editar['nombre']) : '' ?>" required>
                        </div>
                        <?php if ($modo_edicion): ?>
                            <div class="mb-3">
                                <label class="form-label">Estado</label>
                                <select name="estado" class="form-select">
                                    <option value="activo" <?= $nivel_editar['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
                                    <option value="inactivo" <?= $nivel_editar['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
                                </select>
                            </div>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary flex-fill"><i class="bi bi-save me-2"></i>Guardar</button>
                                <a href="niveles.php" class="btn btn-secondary">Cancelar</a>
                            </div>
                        <?php else: ?>
                            <button type="submit" class="btn btn-primary w-100"><i class="bi bi-plus-circle me-2"></i>Crear</button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card">
                    <h5 class="mb-3">Niveles Registrados</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead><tr><th>Nombre</th><th>Estado</th><th>Acciones</th></tr></thead>
                            <tbody>
                                <?php foreach ($niveles as $n): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($n['nombre']) ?></strong></td>
                                    <td><span class="badge bg-<?= $n['estado'] === 'activo' ? 'success' : 'secondary' ?>"><?= $n['estado'] ?></span></td>
                                    <td>
                                        <a href="niveles.php?editar=<?= $n['id'] ?>" class="btn btn-sm btn-primary" title="Editar"><i class="bi bi-pencil"></i></a>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿<?= $n['estado'] === 'activo' ? 'Desactivar' : 'Activar' ?> nivel?')">
                                            <input type="hidden" name="accion" value="toggle_estado">
                                            <input type="hidden" name="id" value="<?= $n['id'] ?>">
                                            <button class="btn btn-sm btn-<?= $n['estado'] === 'activo' ? 'warning' : 'success' ?>" title="<?= $n['estado'] === 'activo' ? 'Desactivar' : 'Activar' ?>"><i class="bi bi-<?= $n['estado'] === 'activo' ? 'pause' : 'play' ?>-fill"></i></button>
                                        </form>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar nivel?')">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <input type="hidden" name="id" value="<?= $n['id'] ?>">
                                            <button class="btn btn-sm btn-danger" title="Eliminar"><i class="bi bi-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
