<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $parametros = [
        'nombre_institucion' => $_POST['nombre_institucion'] ?? '',
        'email_sistema' => $_POST['email_sistema'] ?? '',
        'max_faltas_riesgo' => $_POST['max_faltas_riesgo'] ?? 15,
        'max_tardanzas_alerta' => $_POST['max_tardanzas_alerta'] ?? 10,
        'intervalo_notificacion_inasistencia' => $_POST['intervalo_notificacion_inasistencia'] ?? 90,
        'email_smtp_host' => $_POST['email_smtp_host'] ?? '',
        'email_smtp_port' => $_POST['email_smtp_port'] ?? '587',
        'email_smtp_user' => $_POST['email_smtp_user'] ?? '',
        'email_smtp_pass' => $_POST['email_smtp_pass'] ?? '',
    ];

    // Procesar subida de logo si existe
    if (isset($_FILES['logo_archivo']) && $_FILES['logo_archivo']['error'] === UPLOAD_ERR_OK) {
        $archivo = $_FILES['logo_archivo'];
        $nombre_archivo = $archivo['name'];
        $tipo_archivo = $archivo['type'];
        $tamano_archivo = $archivo['size'];
        $tmp_archivo = $archivo['tmp_name'];

        // Validar tipo de imagen
        $tipos_permitidos = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        if (!in_array($tipo_archivo, $tipos_permitidos)) {
            setAlerta('danger', 'El logo debe ser una imagen (JPG, PNG, GIF o WebP)');
            header('Location: parametros.php');
            exit;
        }

        // Validar tamaño (máximo 2MB)
        if ($tamano_archivo > 2 * 1024 * 1024) {
            setAlerta('danger', 'El logo no debe exceder los 2MB');
            header('Location: parametros.php');
            exit;
        }

        // Crear directorio de uploads si no existe
        $directorio_uploads = '../assets/uploads/logos/';
        if (!file_exists($directorio_uploads)) {
            mkdir($directorio_uploads, 0755, true);
        }

        // Generar nombre único
        $extension = pathinfo($nombre_archivo, PATHINFO_EXTENSION);
        $nombre_unico = 'logo_' . time() . '_' . uniqid() . '.' . $extension;
        $ruta_destino = $directorio_uploads . $nombre_unico;

        // Mover archivo
        if (move_uploaded_file($tmp_archivo, $ruta_destino)) {
            // Guardar la ruta relativa (sin ../)
            $parametros['logo_institucion'] = 'assets/uploads/logos/' . $nombre_unico;
        } else {
            setAlerta('danger', 'Error al subir el logo');
            header('Location: parametros.php');
            exit;
        }
    } elseif (!empty($_POST['logo_institucion_url'])) {
        // Si se proporciona una URL externa
        $parametros['logo_institucion'] = $_POST['logo_institucion_url'];
    }

    foreach ($parametros as $key => $value) {
        query("INSERT INTO configuracion (parametro, valor) VALUES (?, ?) ON DUPLICATE KEY UPDATE valor = ?", [$key, $value, $value]);
    }

    setAlerta('success', 'Parámetros actualizados');
    header('Location: parametros.php');
    exit;
}

// Obtener configuración actual
$config = [];
$cfg = query("SELECT * FROM configuracion")->fetchAll();
foreach ($cfg as $c) {
    $config[$c['parametro']] = $c['valor'];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Parámetros</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div><h3 class="mb-1">Parámetros del Sistema</h3><p class="text-muted mb-0">Configuración general y límites</p></div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-6">
                    <div class="content-card mb-4">
                        <h5 class="mb-3"><i class="bi bi-building me-2"></i>Institución</h5>
                        <div class="mb-3"><label class="form-label">Nombre</label><input type="text" name="nombre_institucion" class="form-control" value="<?= htmlspecialchars($config['nombre_institucion'] ?? '') ?>"></div>
                        <div class="mb-3">
                            <label class="form-label">Logo de la Institución</label>
                            <input type="file" name="logo_archivo" class="form-control" accept="image/jpeg,image/png,image/gif,image/webp">
                            <small class="text-muted">Subir imagen (JPG, PNG, GIF o WebP - Máx. 2MB)</small>
                        </div>
                        <?php if (!empty($config['logo_institucion'])): ?>
                        <div class="mb-3">
                            <label class="form-label">Logo Actual</label>
                            <div>
                                <img src="<?= htmlspecialchars($config['logo_institucion']) ?>" alt="Logo actual" style="max-height: 60px; max-width: 200px; border: 1px solid #dee2e6; padding: 5px;">
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="mb-3">
                            <label class="form-label">O URL externa del logo</label>
                            <input type="text" name="logo_institucion_url" class="form-control" value="" placeholder="https://ejemplo.com/logo.png">
                            <small class="text-muted">Opcional: URL completa del logotipo (prioridad al archivo subido)</small>
                        </div>
                        <div class="mb-3"><label class="form-label">Email del Sistema</label><input type="email" name="email_sistema" class="form-control" value="<?= htmlspecialchars($config['email_sistema'] ?? '') ?>"></div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="content-card mb-4">
                        <h5 class="mb-3"><i class="bi bi-exclamation-triangle me-2"></i>Límites y Alertas</h5>
                        <div class="mb-3"><label class="form-label">Máx. Faltas (Riesgo)</label><input type="number" name="max_faltas_riesgo" class="form-control" value="<?= $config['max_faltas_riesgo'] ?? 15 ?>"></div>
                        <div class="mb-3"><label class="form-label">Máx. Tardanzas (Alerta)</label><input type="number" name="max_tardanzas_alerta" class="form-control" value="<?= $config['max_tardanzas_alerta'] ?? 10 ?>"></div>
                        <div class="mb-3">
                            <label class="form-label">Intervalo Notificación Inasistencia (minutos)</label>
                            <input type="number" name="intervalo_notificacion_inasistencia" class="form-control" value="<?= $config['intervalo_notificacion_inasistencia'] ?? 90 ?>" min="1" max="480">
                            <small class="text-muted">Tiempo después de la hora de ingreso para enviar notificación de ausencia (ej: 90 = 1.5 horas)</small>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="content-card mb-4">
                        <h5 class="mb-3"><i class="bi bi-envelope-fill me-2"></i>Configuración SMTP (Correos)</h5>
                        <div class="row">
                            <div class="col-md-6"><label class="form-label">Servidor SMTP</label><input type="text" name="email_smtp_host" class="form-control" value="<?= htmlspecialchars($config['email_smtp_host'] ?? '') ?>"></div>
                            <div class="col-md-3"><label class="form-label">Puerto</label><input type="text" name="email_smtp_port" class="form-control" value="<?= htmlspecialchars($config['email_smtp_port'] ?? '587') ?>"></div>
                            <div class="col-md-3"><label class="form-label">Usuario</label><input type="text" name="email_smtp_user" class="form-control" value="<?= htmlspecialchars($config['email_smtp_user'] ?? '') ?>"></div>
                            <div class="col-md-6"><label class="form-label">Contraseña</label><input type="password" name="email_smtp_pass" class="form-control" value="<?= htmlspecialchars($config['email_smtp_pass'] ?? '') ?>"></div>
                        </div>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn btn-primary btn-lg"><i class="bi bi-save me-2"></i>Guardar Cambios</button>
        </form>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
