-- =============================================
-- SICA - Sistema Integrado de Convivencia y Asistencia
-- Base de datos: SICA2025
-- Fecha de exportación: 2025-12-28 21:52:07
-- Compatible con MySQL 5.7+ y MariaDB 10.2+
-- =============================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
SET NAMES utf8mb4;

DROP DATABASE IF EXISTS `SICA2025`;
CREATE DATABASE `SICA2025` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `SICA2025`;

--
-- Estructura de tabla `anios_lectivos`
--
DROP TABLE IF EXISTS `anios_lectivos`;
CREATE TABLE `anios_lectivos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anio` varchar(20) NOT NULL,
  `fecha_inicio` date NOT NULL,
  `fecha_fin` date NOT NULL,
  `estado` enum('activo','inactivo','finalizado') DEFAULT 'inactivo',
  `observaciones` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `anio` (`anio`),
  KEY `idx_anio` (`anio`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `anios_lectivos`
--
LOCK TABLES `anios_lectivos` WRITE;
INSERT INTO `anios_lectivos` (`id`, `anio`, `fecha_inicio`, `fecha_fin`, `estado`, `observaciones`, `created_at`, `updated_at`) VALUES
(1, 2025, '2025-03-03', '2025-12-20', 'activo', NULL, '2025-12-28 13:39:03', '2025-12-28 14:06:29'),
(2, 2026, '2026-03-02', '2026-12-19', 'inactivo', NULL, '2025-12-28 13:39:03', '2025-12-28 14:06:22'),
(5, 2027, '2027-03-03', '2027-12-19', 'inactivo', NULL, '2025-12-28 14:05:16', '2025-12-28 14:06:29');
UNLOCK TABLES;

--
-- Estructura de tabla `apoderados`
--
DROP TABLE IF EXISTS `apoderados`;
CREATE TABLE `apoderados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) DEFAULT NULL,
  `dni` varchar(8) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `telefono` varchar(20) NOT NULL,
  `telefono_alternativo` varchar(20) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('M','F') DEFAULT NULL,
  `estado` enum('activo','inactivo','retirado') DEFAULT 'activo',
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `dni` (`dni`),
  KEY `id_usuario` (`id_usuario`),
  KEY `idx_dni` (`dni`),
  KEY `idx_apellidos` (`apellido_paterno`,`apellido_materno`),
  KEY `idx_nombres` (`nombres`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `apoderados_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `areas_academicas`
--
DROP TABLE IF EXISTS `areas_academicas`;
CREATE TABLE `areas_academicas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `area` varchar(100) NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_nivel_anio_area` (`id_nivel`,`id_anio_lectivo`,`area`),
  KEY `idx_nivel` (`id_nivel`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `areas_academicas_ibfk_1` FOREIGN KEY (`id_nivel`) REFERENCES `niveles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `areas_academicas_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `areas_academicas`
--
LOCK TABLES `areas_academicas` WRITE;
INSERT INTO `areas_academicas` (`id`, `id_nivel`, `id_anio_lectivo`, `area`, `estado`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 'Comunicación', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(2, 1, 1, 'Matemática', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 1, 1, 'Personal Social', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(4, 1, 1, 'Ciencia y Ambiente', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(5, 1, 1, 'Arte y Cultura', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(6, 1, 1, 'Educación Física', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(7, 1, 1, 'Educación Religiosa', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(8, 2, 1, 'Comunicación', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(9, 2, 1, 'Matemática', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(10, 2, 1, 'Personal Social', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(11, 2, 1, 'Ciencia y Ambiente', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(12, 2, 1, 'Arte y Cultura', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(13, 2, 1, 'Educación Física', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(14, 2, 1, 'Educación Religiosa', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(15, 2, 1, 'Inglés', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(16, 2, 1, 'Computación', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(17, 3, 1, 'Comunicación', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(18, 3, 1, 'Matemática', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(19, 3, 1, 'Ciencias Sociales', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(20, 3, 1, 'Ciencia, Tecnología y Ambiente', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(21, 3, 1, 'Educación para el Trabajo', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(22, 3, 1, 'Educación Física', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(23, 3, 1, 'Educación Religiosa', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(24, 3, 1, 'Inglés', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(25, 3, 1, 'Arte y Cultura', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(26, 3, 1, 'Desarrollo Personal, Ciudadanía y Cívica', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(31, 3, 1, 'Tutoría', 'activo', '2025-12-28 13:39:03', '2025-12-28 14:28:59');
UNLOCK TABLES;

--
-- Estructura de tabla `asistencias`
--
DROP TABLE IF EXISTS `asistencias`;
CREATE TABLE `asistencias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_estudiante` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `id_programacion` int(11) NOT NULL,
  `id_turno` int(11) NOT NULL,
  `id_estado_asistencia` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `hora_registro` time NOT NULL,
  `estado_codigo` varchar(50) NOT NULL,
  `minutos_tardanza` int(11) DEFAULT 0,
  `registrado_por` varchar(50) NOT NULL,
  `metodo_registro` enum('qr','manual','automatico') DEFAULT 'manual',
  `observaciones` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_turno` (`id_turno`),
  KEY `id_estado_asistencia` (`id_estado_asistencia`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_fecha` (`fecha`),
  KEY `idx_programacion` (`id_programacion`),
  CONSTRAINT `asistencias_ibfk_1` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asistencias_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asistencias_ibfk_3` FOREIGN KEY (`id_programacion`) REFERENCES `programaciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asistencias_ibfk_4` FOREIGN KEY (`id_turno`) REFERENCES `turnos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asistencias_ibfk_5` FOREIGN KEY (`id_estado_asistencia`) REFERENCES `estados_asistencia` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `auxiliares`
--
DROP TABLE IF EXISTS `auxiliares`;
CREATE TABLE `auxiliares` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) DEFAULT NULL,
  `dni` varchar(8) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('M','F') DEFAULT NULL,
  `id_turno` int(11) DEFAULT NULL COMMENT 'Turno asignado (opcional)',
  `estado` enum('activo','inactivo','retirado') DEFAULT 'activo',
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `dni` (`dni`),
  KEY `id_usuario` (`id_usuario`),
  KEY `idx_dni` (`dni`),
  KEY `idx_apellidos` (`apellido_paterno`,`apellido_materno`),
  KEY `idx_nombres` (`nombres`),
  KEY `idx_turno` (`id_turno`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `auxiliares_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL,
  CONSTRAINT `auxiliares_ibfk_2` FOREIGN KEY (`id_turno`) REFERENCES `turnos` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `auxiliares`
--
LOCK TABLES `auxiliares` WRITE;
INSERT INTO `auxiliares` (`id`, `id_usuario`, `dni`, `apellido_paterno`, `apellido_materno`, `nombres`, `email`, `telefono`, `direccion`, `fecha_nacimiento`, `genero`, `id_turno`, `estado`, `fecha_registro`, `updated_at`) VALUES
(2, 7, 41774130, 'RAYGADA', 'VASQUEZ', 'ALICIA LISEETH', 'ALICIA@SANJOSE.EDU.PE', 741852963, 'LA ESPERANZA', '1982-12-14', 'F', 5, 'activo', '2025-12-28 15:12:11', '2025-12-28 15:12:11');
UNLOCK TABLES;

--
-- Estructura de tabla `calendario`
--
DROP TABLE IF EXISTS `calendario`;
CREATE TABLE `calendario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  `tipo` enum('feriado','vacacion','dia_no_laboral','fin_semana_largo') NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `aniolectivo_id` int(11) DEFAULT NULL,
  `afecta_todos_niveles` tinyint(1) DEFAULT 1,
  `niveles_afectados` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`niveles_afectados`)),
  `observaciones` text DEFAULT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `fecha` (`fecha`),
  KEY `idx_fecha` (`fecha`),
  KEY `idx_tipo` (`tipo`),
  KEY `idx_aniolectivo` (`aniolectivo_id`),
  KEY `idx_estado` (`estado`),
  KEY `idx_unique_fecha` (`fecha`),
  CONSTRAINT `calendario_ibfk_1` FOREIGN KEY (`aniolectivo_id`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `calendario`
--
LOCK TABLES `calendario` WRITE;
INSERT INTO `calendario` (`id`, `fecha`, `tipo`, `nombre`, `descripcion`, `aniolectivo_id`, `afecta_todos_niveles`, `niveles_afectados`, `observaciones`, `estado`, `created_at`, `updated_at`) VALUES
(1, '2025-01-01', 'feriado', 'Año Nuevo', 'Año Nuevo', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(2, '2025-04-10', 'feriado', 'Jueves Santo', 'Jueves Santo', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, '2025-04-11', 'feriado', 'Viernes Santo', 'Viernes Santo', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(4, '2025-05-01', 'feriado', 'Día del Trabajo', 'Día del Trabajo', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(5, '2025-06-29', 'feriado', 'San Pedro y San Pablo', 'San Pedro y San Pablo', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(6, '2025-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Día de la Independencia', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(7, '2025-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(8, '2025-08-30', 'feriado', 'Santa Rosa de Lima', 'Santa Rosa de Lima', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(9, '2025-10-08', 'feriado', 'Combate de Angamos', 'Combate de Angamos', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(10, '2025-11-01', 'feriado', 'Todos los Santos', 'Todos los Santos', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(11, '2025-12-08', 'feriado', 'Inmaculada Concepción', 'Inmaculada Concepción', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(12, '2025-12-25', 'feriado', 'Navidad', 'Navidad', 1, 1, NULL, NULL, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `configuracion`
--
DROP TABLE IF EXISTS `configuracion`;
CREATE TABLE `configuracion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parametro` varchar(100) NOT NULL,
  `valor` text DEFAULT NULL,
  `descripcion` text DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `parametro` (`parametro`),
  KEY `idx_parametro` (`parametro`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `configuracion`
--
LOCK TABLES `configuracion` WRITE;
INSERT INTO `configuracion` (`id`, `parametro`, `valor`, `descripcion`, `updated_at`) VALUES
(1, 'anio_lectivo_activo', 1, 'Año lectivo actualmente activo (ID)', '2025-12-28 13:39:03'),
(2, 'intervalo_notificacion_inasistencia', 90, 'Intervalo en minutos para notificar ausencia automática', '2025-12-28 13:39:03'),
(3, 'tolerancia_default', 15, 'Tolerancia en minutos por defecto para tardanzas', '2025-12-28 13:39:03'),
(4, 'max_faltas_riesgo', 10, 'Número máximo de faltas injustificadas antes de alerta de riesgo', '2025-12-28 13:39:03'),
(5, 'max_tardanzas_riesgo', 15, 'Número máximo de tardanzas antes de alerta de riesgo', '2025-12-28 13:39:03'),
(6, 'max_incidencias_riesgo', 5, 'Número máximo de incidencias graves antes de alerta de riesgo', '2025-12-28 13:39:03'),
(7, 'email_sistema', 'notificaciones@sica.edu', 'Correo electrónico del sistema para envío de notificaciones', '2025-12-28 13:39:03'),
(8, 'nombre_institucion', 'SICA - Sistema Integrado de Convivencia y Asistencia', 'Nombre de la institución educativa', '2025-12-28 13:39:03'),
(9, 'telefono_institucion', '(01) 123-4567', 'Teléfono de la institución', '2025-12-28 13:39:03'),
(10, 'direccion_institucion', 'Av. Principal 123, Lima, Perú', 'Dirección de la institución', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `docente_areas`
--
DROP TABLE IF EXISTS `docente_areas`;
CREATE TABLE `docente_areas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_docente` int(11) NOT NULL,
  `id_area_academica` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `fecha_asignacion` date DEFAULT curdate(),
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_docente_area_anio` (`id_docente`,`id_area_academica`,`id_anio_lectivo`),
  KEY `idx_docente` (`id_docente`),
  KEY `idx_area_academica` (`id_area_academica`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  CONSTRAINT `docente_areas_ibfk_1` FOREIGN KEY (`id_docente`) REFERENCES `docentes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `docente_areas_ibfk_2` FOREIGN KEY (`id_area_academica`) REFERENCES `areas_academicas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `docente_areas_ibfk_3` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `docentes`
--
DROP TABLE IF EXISTS `docentes`;
CREATE TABLE `docentes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) DEFAULT NULL,
  `dni` varchar(8) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('M','F') DEFAULT NULL,
  `especialidad` varchar(100) DEFAULT NULL,
  `estado` enum('activo','inactivo','retirado') DEFAULT 'activo',
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `dni` (`dni`),
  KEY `id_usuario` (`id_usuario`),
  KEY `idx_dni` (`dni`),
  KEY `idx_apellidos` (`apellido_paterno`,`apellido_materno`),
  KEY `idx_nombres` (`nombres`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `docentes_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `docentes`
--
LOCK TABLES `docentes` WRITE;
INSERT INTO `docentes` (`id`, `id_usuario`, `dni`, `apellido_paterno`, `apellido_materno`, `nombres`, `email`, `telefono`, `direccion`, `fecha_nacimiento`, `genero`, `especialidad`, `estado`, `fecha_registro`, `updated_at`) VALUES
(2, 6, 41774132, 'LOPEZ', 'RODRIGUEZ', 'ALEX MIKY', 'MIKYLOPEZ@GMAIL.COM', 949614040, 'TRUJILLO 235', '1982-12-14', 'M', NULL, 'activo', '2025-12-28 14:44:18', '2025-12-28 14:44:18');
UNLOCK TABLES;

--
-- Estructura de tabla `estados_asistencia`
--
DROP TABLE IF EXISTS `estados_asistencia`;
CREATE TABLE `estados_asistencia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `abreviatura` varchar(10) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `color` varchar(20) DEFAULT '#6c757d',
  `icono` varchar(50) DEFAULT 'circle-fill',
  `conteo_asistencia` enum('si','no') DEFAULT 'si',
  `permite_tardanza` enum('si','no') DEFAULT 'no',
  `requiere_justificacion` enum('si','no') DEFAULT 'no',
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`),
  UNIQUE KEY `abreviatura` (`abreviatura`),
  KEY `idx_nombre` (`nombre`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `estados_asistencia`
--
LOCK TABLES `estados_asistencia` WRITE;
INSERT INTO `estados_asistencia` (`id`, `nombre`, `abreviatura`, `descripcion`, `color`, `icono`, `conteo_asistencia`, `permite_tardanza`, `requiere_justificacion`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Asistencia', 'ASI', 'Asistencia completa y puntual', '#10b981', 'check-circle-fill', 'si', 'no', 'no', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(2, 'Tardanza', 'TAR', 'Llegó después de la hora de ingreso', '#f59e0b', 'clock-fill', 'si', 'si', 'no', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 'Tardanza Justificada', 'TJU', 'Tardanza con justificación documentada', '#3b82f6', 'clock-history', 'si', 'si', 'si', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(4, 'Falta Justificada', 'FJU', 'Falta con justificación documentada', '#8b5cf6', 'check-square', 'si', '', '', 'activo', '2025-12-28 13:39:03', '2025-12-28 14:32:59'),
(5, 'Falta Injustificada', 'FIN', 'Falta sin justificación', '#ef4444', 'x-circle-fill', 'no', 'no', 'no', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `estudiantes`
--
DROP TABLE IF EXISTS `estudiantes`;
CREATE TABLE `estudiantes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) DEFAULT NULL,
  `dni` varchar(8) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `fecha_nacimiento` date NOT NULL,
  `genero` enum('M','F') NOT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `estado` enum('activo','inactivo','retirado','trasladado') DEFAULT 'activo',
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `dni` (`dni`),
  KEY `id_usuario` (`id_usuario`),
  KEY `idx_dni` (`dni`),
  KEY `idx_apellidos` (`apellido_paterno`,`apellido_materno`),
  KEY `idx_nombres` (`nombres`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `estudiantes_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `estudiantes_apoderados`
--
DROP TABLE IF EXISTS `estudiantes_apoderados`;
CREATE TABLE `estudiantes_apoderados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_estudiante` int(11) NOT NULL,
  `id_apoderado` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `parentesco` varchar(50) DEFAULT 'Padre/Madre',
  `es_principal` tinyint(1) DEFAULT 0,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_estudiante_anio` (`id_estudiante`,`id_anio_lectivo`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_apoderado` (`id_apoderado`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  CONSTRAINT `estudiantes_apoderados_ibfk_1` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `estudiantes_apoderados_ibfk_2` FOREIGN KEY (`id_apoderado`) REFERENCES `apoderados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `estudiantes_apoderados_ibfk_3` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `grados`
--
DROP TABLE IF EXISTS `grados`;
CREATE TABLE `grados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `grado` varchar(20) NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_nivel_anio_grado` (`id_nivel`,`id_anio_lectivo`,`grado`),
  KEY `idx_nivel` (`id_nivel`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `grados_ibfk_1` FOREIGN KEY (`id_nivel`) REFERENCES `niveles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grados_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `grados`
--
LOCK TABLES `grados` WRITE;
INSERT INTO `grados` (`id`, `id_nivel`, `id_anio_lectivo`, `grado`, `estado`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '3 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 14:07:07'),
(2, 1, 1, '4 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 1, 1, '5 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(4, 2, 1, '1°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(5, 2, 1, '2°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(6, 2, 1, '3°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(7, 2, 1, '4°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(8, 2, 1, '5°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(9, 2, 1, '6°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(10, 3, 1, '1°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(11, 3, 1, '2°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(12, 3, 1, '3°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(13, 3, 1, '4°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(14, 3, 1, '5°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(15, 1, 2, '3 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(16, 1, 2, '4 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(17, 1, 2, '5 años', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(18, 2, 2, '1°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(19, 2, 2, '2°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(20, 2, 2, '3°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(21, 2, 2, '4°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(22, 2, 2, '5°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(23, 2, 2, '6°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(24, 3, 2, '1°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(25, 3, 2, '2°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(26, 3, 2, '3°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(27, 3, 2, '4°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(28, 3, 2, '5°', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `horarios`
--
DROP TABLE IF EXISTS `horarios`;
CREATE TABLE `horarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `id_turno` int(11) NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_nivel_anio_turno` (`id_nivel`,`id_anio_lectivo`,`id_turno`),
  KEY `idx_nivel` (`id_nivel`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_turno` (`id_turno`),
  CONSTRAINT `horarios_ibfk_1` FOREIGN KEY (`id_nivel`) REFERENCES `niveles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `horarios_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `horarios_ibfk_3` FOREIGN KEY (`id_turno`) REFERENCES `turnos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `horarios`
--
LOCK TABLES `horarios` WRITE;
INSERT INTO `horarios` (`id`, `id_nivel`, `id_anio_lectivo`, `id_turno`, `estado`, `created_at`, `updated_at`) VALUES
(7, 1, 1, 3, 'activo', '2025-12-28 14:30:09', '2025-12-28 14:30:09'),
(8, 2, 1, 1, 'activo', '2025-12-28 14:31:07', '2025-12-28 14:31:07'),
(9, 2, 1, 2, 'activo', '2025-12-28 14:31:18', '2025-12-28 14:31:18'),
(10, 3, 1, 4, 'activo', '2025-12-28 14:31:28', '2025-12-28 14:31:28'),
(11, 3, 1, 5, 'activo', '2025-12-28 14:31:35', '2025-12-28 14:31:35');
UNLOCK TABLES;

--
-- Estructura de tabla `incidencias`
--
DROP TABLE IF EXISTS `incidencias`;
CREATE TABLE `incidencias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_estudiante` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `id_tipo_incidencia` int(11) NOT NULL,
  `id_docente` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `hora` time NOT NULL,
  `descripcion` text NOT NULL,
  `estado` enum('activo','resuelto','archivado') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_docente` (`id_docente`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_fecha` (`fecha`),
  KEY `idx_tipo` (`id_tipo_incidencia`),
  CONSTRAINT `incidencias_ibfk_1` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `incidencias_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `incidencias_ibfk_3` FOREIGN KEY (`id_tipo_incidencia`) REFERENCES `tipos_incidencia` (`id`),
  CONSTRAINT `incidencias_ibfk_4` FOREIGN KEY (`id_docente`) REFERENCES `docentes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `niveles`
--
DROP TABLE IF EXISTS `niveles`;
CREATE TABLE `niveles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`),
  KEY `idx_nombre` (`nombre`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `niveles`
--
LOCK TABLES `niveles` WRITE;
INSERT INTO `niveles` (`id`, `nombre`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Inicial', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(2, 'Primaria', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 'Secundaria', 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `notificaciones`
--
DROP TABLE IF EXISTS `notificaciones`;
CREATE TABLE `notificaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_apoderado` int(11) NOT NULL,
  `id_estudiante` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `tipo` enum('inasistencia','tardanza','falta_repetida','alerta') NOT NULL,
  `titulo` varchar(200) NOT NULL,
  `mensaje` text NOT NULL,
  `fecha_notificacion` datetime DEFAULT current_timestamp(),
  `leida` tinyint(1) DEFAULT 0,
  `fecha_lectura` datetime DEFAULT NULL,
  `email_enviado` tinyint(1) DEFAULT 0,
  `fecha_email` datetime DEFAULT NULL,
  `estado` enum('activo','archivado') DEFAULT 'activo',
  PRIMARY KEY (`id`),
  KEY `id_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_apoderado` (`id_apoderado`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_leida` (`leida`),
  KEY `idx_fecha` (`fecha_notificacion`),
  KEY `idx_tipo` (`tipo`),
  CONSTRAINT `notificaciones_ibfk_1` FOREIGN KEY (`id_apoderado`) REFERENCES `apoderados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notificaciones_ibfk_2` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notificaciones_ibfk_3` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `notificaciones_email`
--
DROP TABLE IF EXISTS `notificaciones_email`;
CREATE TABLE `notificaciones_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_apoderado` int(11) NOT NULL,
  `id_estudiante` int(11) NOT NULL,
  `id_referencia` int(11) DEFAULT NULL COMMENT 'ID de referencia (asistencia, incidencia, etc.)',
  `tipo_notificacion` enum('inasistencia','tardanza','falta_repetida','alerta','incidencia') NOT NULL,
  `asunto` varchar(255) NOT NULL,
  `mensaje` text NOT NULL,
  `estado_envio` enum('pendiente','enviado','error') DEFAULT 'pendiente',
  `intentos` int(11) DEFAULT 0 COMMENT 'Número de intentos de envío',
  `email_enviado` varchar(255) DEFAULT NULL COMMENT 'Email al que se envió',
  `fecha_envio` datetime DEFAULT NULL COMMENT 'Fecha y hora de envío exitoso',
  `error_mensaje` text DEFAULT NULL COMMENT 'Mensaje de error si falló el envío',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_apoderado` (`id_apoderado`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_estado_envio` (`estado_envio`),
  KEY `idx_tipo` (`tipo_notificacion`),
  KEY `idx_fecha_envio` (`fecha_envio`),
  CONSTRAINT `notificaciones_email_ibfk_1` FOREIGN KEY (`id_apoderado`) REFERENCES `apoderados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notificaciones_email_ibfk_2` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `programaciones`
--
DROP TABLE IF EXISTS `programaciones`;
CREATE TABLE `programaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_seccion` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `id_tutor` int(11) DEFAULT NULL,
  `id_auxiliar` int(11) DEFAULT NULL,
  `id_turno` int(11) NOT NULL,
  `capacidad` int(11) DEFAULT 40,
  `estado` enum('activo','inactivo','finalizado') DEFAULT 'activo',
  `observaciones` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_seccion_anio` (`id_seccion`,`id_anio_lectivo`),
  KEY `id_turno` (`id_turno`),
  KEY `idx_seccion` (`id_seccion`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_tutor` (`id_tutor`),
  KEY `idx_auxiliar` (`id_auxiliar`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `programaciones_ibfk_1` FOREIGN KEY (`id_seccion`) REFERENCES `secciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programaciones_ibfk_2` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programaciones_ibfk_3` FOREIGN KEY (`id_tutor`) REFERENCES `docentes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `programaciones_ibfk_4` FOREIGN KEY (`id_auxiliar`) REFERENCES `auxiliares` (`id`) ON DELETE SET NULL,
  CONSTRAINT `programaciones_ibfk_5` FOREIGN KEY (`id_turno`) REFERENCES `turnos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `programaciones`
--
LOCK TABLES `programaciones` WRITE;
INSERT INTO `programaciones` (`id`, `id_seccion`, `id_anio_lectivo`, `id_tutor`, `id_auxiliar`, `id_turno`, `capacidad`, `estado`, `observaciones`, `created_at`, `updated_at`) VALUES
(1, 55, 1, 2, 2, 2, 35, 'activo', '', '2025-12-28 15:09:46', '2025-12-28 15:19:08');
UNLOCK TABLES;

--
-- Estructura de tabla `programaciones_docentes_areas`
--
DROP TABLE IF EXISTS `programaciones_docentes_areas`;
CREATE TABLE `programaciones_docentes_areas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_programacion` int(11) NOT NULL,
  `id_docente` int(11) NOT NULL,
  `id_area_academica` int(11) NOT NULL,
  `fecha_asignacion` date DEFAULT curdate(),
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `observaciones` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_programacion_docente_area` (`id_programacion`,`id_docente`,`id_area_academica`),
  KEY `idx_programacion` (`id_programacion`),
  KEY `idx_docente` (`id_docente`),
  KEY `idx_area_academica` (`id_area_academica`),
  CONSTRAINT `programaciones_docentes_areas_ibfk_1` FOREIGN KEY (`id_programacion`) REFERENCES `programaciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programaciones_docentes_areas_ibfk_2` FOREIGN KEY (`id_docente`) REFERENCES `docentes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programaciones_docentes_areas_ibfk_3` FOREIGN KEY (`id_area_academica`) REFERENCES `areas_academicas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `programaciones_docentes_areas`
--
LOCK TABLES `programaciones_docentes_areas` WRITE;
INSERT INTO `programaciones_docentes_areas` (`id`, `id_programacion`, `id_docente`, `id_area_academica`, `fecha_asignacion`, `estado`, `observaciones`, `created_at`) VALUES
(1, 1, 2, 21, '2025-12-28', 'activo', NULL, '2025-12-28 15:18:27'),
(2, 1, 2, 31, '2025-12-28', 'activo', NULL, '2025-12-28 15:18:27');
UNLOCK TABLES;

--
-- Estructura de tabla `programaciones_estudiantes`
--
DROP TABLE IF EXISTS `programaciones_estudiantes`;
CREATE TABLE `programaciones_estudiantes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_programacion` int(11) NOT NULL,
  `id_estudiante` int(11) NOT NULL,
  `fecha_asignacion` date DEFAULT curdate(),
  `estado` enum('activo','trasladado','retirado') DEFAULT 'activo',
  `observaciones` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_programacion_estudiante` (`id_programacion`,`id_estudiante`),
  KEY `idx_programacion` (`id_programacion`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `programaciones_estudiantes_ibfk_1` FOREIGN KEY (`id_programacion`) REFERENCES `programaciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programaciones_estudiantes_ibfk_2` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla `secciones`
--
DROP TABLE IF EXISTS `secciones`;
CREATE TABLE `secciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(11) NOT NULL,
  `id_grado` int(11) NOT NULL,
  `id_turno` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `seccion` varchar(10) NOT NULL,
  `grado` varchar(20) NOT NULL COMMENT 'Nombre del grado (redundante para facilitar búsquedas)',
  `capacidad` int(11) DEFAULT 40,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_nivel_grado_turno_seccion_anio` (`id_nivel`,`id_grado`,`id_turno`,`seccion`,`id_anio_lectivo`),
  KEY `id_grado` (`id_grado`),
  KEY `idx_nivel` (`id_nivel`),
  KEY `idx_turno` (`id_turno`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `secciones_ibfk_1` FOREIGN KEY (`id_nivel`) REFERENCES `niveles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `secciones_ibfk_2` FOREIGN KEY (`id_grado`) REFERENCES `grados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `secciones_ibfk_3` FOREIGN KEY (`id_turno`) REFERENCES `turnos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `secciones_ibfk_4` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `secciones`
--
LOCK TABLES `secciones` WRITE;
INSERT INTO `secciones` (`id`, `id_nivel`, `id_grado`, `id_turno`, `id_anio_lectivo`, `seccion`, `grado`, `capacidad`, `estado`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 1, 1, 'A', '3 años', 25, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 1, 2, 1, 1, 'A', '4 años', 25, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(9, 1, 3, 1, 1, 'A', '5 años', 25, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:22:05'),
(10, 2, 4, 1, 1, 'A', '1°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(11, 2, 4, 1, 1, 'B', '1°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(12, 2, 4, 1, 1, 'C', '1°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(13, 2, 5, 1, 1, 'A', '2°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(14, 2, 5, 1, 1, 'B', '2°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(15, 2, 5, 1, 1, 'C', '2°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(16, 2, 6, 1, 1, 'A', '3°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(17, 2, 6, 1, 1, 'B', '3°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(18, 2, 6, 1, 1, 'C', '3°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(34, 2, 7, 2, 1, 'A', '4°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(35, 2, 7, 2, 1, 'B', '4°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(36, 2, 8, 2, 1, 'A', '5°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(37, 2, 8, 2, 1, 'B', '5°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(38, 2, 9, 2, 1, 'A', '6°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(39, 2, 9, 2, 1, 'B', '6°', 30, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(41, 3, 10, 2, 1, 'C', '1°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:16:15'),
(42, 3, 10, 2, 1, 'D', '1°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:16:27'),
(43, 3, 11, 2, 1, 'B', '2°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:18:04'),
(44, 3, 11, 2, 1, 'D', '2°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:17:37'),
(45, 3, 11, 2, 1, 'E', '2°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:17:26'),
(46, 3, 12, 2, 1, 'B', '3°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:19:42'),
(47, 3, 12, 1, 1, 'D', '3°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:18:28'),
(48, 3, 12, 1, 1, 'E', '3°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:18:18'),
(49, 3, 13, 1, 1, 'B', '4°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:20:31'),
(50, 3, 13, 1, 1, 'D', '4°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:20:06'),
(51, 3, 13, 1, 1, 'E', '4°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:19:58'),
(52, 3, 14, 1, 1, 'B', '5°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:21:28'),
(53, 3, 14, 1, 1, 'D', '5°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:21:06'),
(54, 3, 14, 1, 1, 'E', '5°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:20:59'),
(55, 3, 10, 2, 1, 'A', '1°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(56, 3, 10, 2, 1, 'B', '1°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(57, 3, 11, 2, 1, 'A', '2°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(58, 3, 11, 2, 1, 'C', '2°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:17:49'),
(59, 3, 12, 2, 1, 'A', '3°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(60, 3, 12, 1, 1, 'C', '3°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:18:39'),
(61, 3, 13, 1, 1, 'A', '4°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:20:45'),
(62, 3, 13, 1, 1, 'C', '4°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:20:18'),
(63, 3, 14, 1, 1, 'A', '5°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:21:51'),
(64, 3, 14, 1, 1, 'C', '5°', 35, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:21:17'),
(65, 3, 10, 2, 1, 'E', '1°', 30, 'activo', '2025-12-28 14:17:01', '2025-12-28 14:17:01');
UNLOCK TABLES;

--
-- Estructura de tabla `tipos_incidencia`
--
DROP TABLE IF EXISTS `tipos_incidencia`;
CREATE TABLE `tipos_incidencia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `gravedad` enum('baja','media','alta','muy_alta') DEFAULT 'media',
  `puntos_penalidad` int(11) DEFAULT 0 COMMENT 'Puntos de penalización por este tipo de incidencia',
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `tipo` (`tipo`),
  KEY `idx_tipo` (`tipo`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `tipos_incidencia`
--
LOCK TABLES `tipos_incidencia` WRITE;
INSERT INTO `tipos_incidencia` (`id`, `tipo`, `descripcion`, `gravedad`, `puntos_penalidad`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Falta de respeto', 'Falta de respeto hacia compañeros o personal', 'media', 5, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(2, 'Agresión física', 'Cualquier tipo de agresión física', 'muy_alta', 20, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(3, 'Agresión verbal', 'Insultos o palabras ofensivas', 'alta', 10, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(4, 'Daño a la propiedad', 'Daño intencional a propiedad de la institución o compañeros', 'alta', 15, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(5, 'Incumplimiento de tareas', 'No entrega de tareas o trabajos asignados', 'baja', 2, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(6, 'Inasistencia repetida', 'Faltas injustificadas repetidas', 'media', 5, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(7, 'Uso inapropiado de tecnología', 'Uso inadecuado de dispositivos tecnológicos', 'media', 5, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(8, 'Comportamiento disruptivo', 'Interrupción constante del desarrollo de clases', 'media', 3, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(9, 'Bullying', 'Acoso escolar a compañeros', 'muy_alta', 25, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03'),
(10, 'Fraude académico', 'Copiar o hacer trampa en exámenes', 'alta', 10, 'activo', '2025-12-28 13:39:03', '2025-12-28 13:39:03');
UNLOCK TABLES;

--
-- Estructura de tabla `turnos`
--
DROP TABLE IF EXISTS `turnos`;
CREATE TABLE `turnos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `abreviatura` varchar(20) NOT NULL,
  `hora_ingreso` time NOT NULL,
  `hora_salida` time NOT NULL,
  `tolerancia_minutos` int(11) DEFAULT 15,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`),
  UNIQUE KEY `abreviatura` (`abreviatura`),
  KEY `idx_nombre` (`nombre`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `turnos`
--
LOCK TABLES `turnos` WRITE;
INSERT INTO `turnos` (`id`, `nombre`, `abreviatura`, `hora_ingreso`, `hora_salida`, `tolerancia_minutos`, `estado`, `created_at`, `updated_at`) VALUES
(1, 'Mañana Primaria', 'MAP', '07:00:00', '12:00:00', 0, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:26:17'),
(2, 'Tarde Primaria', 'TAP', '13:00:00', '18:00:00', 0, 'activo', '2025-12-28 13:39:03', '2025-12-28 14:26:33'),
(3, 'Mañana Inicial', 'MAI', '08:00:00', '12:00:00', 0, 'activo', '2025-12-28 14:25:52', '2025-12-28 14:25:52'),
(4, 'Mañana Secundaria', 'MAS', '07:00:00', '12:35:00', 0, 'activo', '2025-12-28 14:26:57', '2025-12-28 14:26:57'),
(5, 'Tarde Secundaria', 'TAS', '13:00:00', '18:35:00', 0, 'activo', '2025-12-28 14:27:16', '2025-12-28 14:27:16');
UNLOCK TABLES;

--
-- Estructura de tabla `usuarios`
--
DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `rol` enum('admin','docente','auxiliar','estudiante','apoderado') NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `ultimo_acceso` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `usuario` (`usuario`),
  KEY `idx_usuario` (`usuario`),
  KEY `idx_rol` (`rol`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para tabla `usuarios`
--
LOCK TABLES `usuarios` WRITE;
INSERT INTO `usuarios` (`id`, `usuario`, `password`, `rol`, `estado`, `fecha_registro`, `ultimo_acceso`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'activo', '2025-12-28 13:39:03', NULL),
(6, 41774132, '$2y$10$j.M9a85fs00VpUiHySv14.uNyZWOXWKd8qEp0zw/.7Oowi2Wlh0bm', 'docente', 'activo', '2025-12-28 14:44:18', NULL),
(7, 41774130, '$2y$10$crhS13.m2nvwHZEk35cyMe4ZNfs2brP5hSpZ9cAr2Yb81bviNGTw6', 'auxiliar', 'activo', '2025-12-28 15:12:11', NULL);
UNLOCK TABLES;

--
-- Estructura de tabla `v_asistencias_detalle`
--
DROP TABLE IF EXISTS `v_asistencias_detalle`;
-- (VISTA - se creará al final del archivo)

--
-- Estructura de tabla `v_calendario_detalle`
--
DROP TABLE IF EXISTS `v_calendario_detalle`;
-- (VISTA - se creará al final del archivo)

--
-- Estructura de tabla `v_estudiantes_programacion`
--
DROP TABLE IF EXISTS `v_estudiantes_programacion`;
-- (VISTA - se creará al final del archivo)

--
-- Estructura de tabla `v_programaciones_resumen`
--
DROP TABLE IF EXISTS `v_programaciones_resumen`;
-- (VISTA - se creará al final del archivo)

-- =============================================
-- VISTAS (creadas después de las tablas)
-- =============================================

DROP VIEW IF EXISTS `v_asistencias_detalle`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_asistencias_detalle` AS select `a`.`id` AS `id`,`a`.`id_estudiante` AS `id_estudiante`,`e`.`dni` AS `dni`,concat(`e`.`apellido_paterno`,' ',`e`.`apellido_materno`,', ',`e`.`nombres`) AS `estudiante_nombre`,`e`.`genero` AS `genero`,`a`.`id_anio_lectivo` AS `id_anio_lectivo`,`an`.`anio` AS `anio_lectivo`,`a`.`id_programacion` AS `id_programacion`,`s`.`id_nivel` AS `id_nivel`,`n`.`nombre` AS `nivel_nombre`,`g`.`grado` AS `grado`,`s`.`seccion` AS `seccion`,`a`.`id_turno` AS `id_turno`,`t`.`nombre` AS `turno_nombre`,`t`.`abreviatura` AS `turno_abreviatura`,`t`.`hora_ingreso` AS `hora_ingreso`,`t`.`hora_salida` AS `hora_salida`,`t`.`tolerancia_minutos` AS `tolerancia_minutos`,`a`.`id_estado_asistencia` AS `id_estado_asistencia`,`ea`.`nombre` AS `estado_nombre`,`ea`.`abreviatura` AS `estado_abreviatura`,`ea`.`color` AS `estado_color`,`ea`.`icono` AS `estado_icono`,`a`.`fecha` AS `fecha`,`a`.`hora_registro` AS `hora_registro`,`a`.`estado_codigo` AS `estado_codigo`,`a`.`minutos_tardanza` AS `minutos_tardanza`,`a`.`registrado_por` AS `registrado_por`,`a`.`metodo_registro` AS `metodo_registro`,`a`.`observaciones` AS `observaciones`,`a`.`created_at` AS `created_at` from ((((((((`asistencias` `a` join `estudiantes` `e` on(`a`.`id_estudiante` = `e`.`id`)) join `anios_lectivos` `an` on(`a`.`id_anio_lectivo` = `an`.`id`)) join `programaciones` `p` on(`a`.`id_programacion` = `p`.`id`)) join `secciones` `s` on(`p`.`id_seccion` = `s`.`id`)) join `niveles` `n` on(`s`.`id_nivel` = `n`.`id`)) join `grados` `g` on(`s`.`id_grado` = `g`.`id`)) join `turnos` `t` on(`a`.`id_turno` = `t`.`id`)) join `estados_asistencia` `ea` on(`a`.`id_estado_asistencia` = `ea`.`id`));

DROP VIEW IF EXISTS `v_calendario_detalle`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_calendario_detalle` AS select `c`.`id` AS `id`,`c`.`fecha` AS `fecha`,dayname(`c`.`fecha`) AS `dia_semana`,dayofmonth(`c`.`fecha`) AS `dia`,month(`c`.`fecha`) AS `mes`,year(`c`.`fecha`) AS `anio`,`c`.`tipo` AS `tipo`,`c`.`nombre` AS `nombre`,`c`.`descripcion` AS `descripcion`,`c`.`aniolectivo_id` AS `aniolectivo_id`,`an`.`anio` AS `anio_lectivo`,`c`.`afecta_todos_niveles` AS `afecta_todos_niveles`,`c`.`niveles_afectados` AS `niveles_afectados`,`c`.`observaciones` AS `observaciones`,`c`.`estado` AS `estado`,case when dayofweek(`c`.`fecha`) in (1,7) then 1 else 0 end AS `es_fin_de_semana` from (`calendario` `c` left join `anios_lectivos` `an` on(`c`.`aniolectivo_id` = `an`.`id`));

DROP VIEW IF EXISTS `v_estudiantes_programacion`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_estudiantes_programacion` AS select `e`.`id` AS `estudiante_id`,`e`.`dni` AS `dni`,concat(`e`.`apellido_paterno`,' ',`e`.`apellido_materno`,', ',`e`.`nombres`) AS `estudiante_nombre`,`e`.`genero` AS `genero`,`pe`.`id_programacion` AS `id_programacion`,`s`.`id_nivel` AS `id_nivel`,`n`.`nombre` AS `nivel`,`g`.`grado` AS `grado`,`s`.`seccion` AS `seccion`,`t`.`nombre` AS `turno`,`t`.`abreviatura` AS `turno_abreviatura`,`p`.`id_anio_lectivo` AS `id_anio_lectivo`,`an`.`anio` AS `anio` from (((((((`estudiantes` `e` join `programaciones_estudiantes` `pe` on(`e`.`id` = `pe`.`id_estudiante`)) join `programaciones` `p` on(`pe`.`id_programacion` = `p`.`id`)) join `secciones` `s` on(`p`.`id_seccion` = `s`.`id`)) join `niveles` `n` on(`s`.`id_nivel` = `n`.`id`)) join `grados` `g` on(`s`.`id_grado` = `g`.`id`)) join `turnos` `t` on(`p`.`id_turno` = `t`.`id`)) join `anios_lectivos` `an` on(`p`.`id_anio_lectivo` = `an`.`id`)) where `pe`.`estado` = 'activo' and `e`.`estado` = 'activo';

DROP VIEW IF EXISTS `v_programaciones_resumen`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_programaciones_resumen` AS select `p`.`id` AS `id`,`p`.`id_seccion` AS `id_seccion`,`p`.`id_anio_lectivo` AS `id_anio_lectivo`,`an`.`anio` AS `anio_lectivo`,`p`.`id_tutor` AS `id_tutor`,concat(`d`.`apellido_paterno`,' ',`d`.`apellido_materno`,', ',`d`.`nombres`) AS `tutor_nombre`,`p`.`id_auxiliar` AS `id_auxiliar`,concat(`a`.`apellido_paterno`,' ',`a`.`apellido_materno`,', ',`a`.`nombres`) AS `auxiliar_nombre`,`p`.`id_turno` AS `id_turno`,`t`.`nombre` AS `turno_nombre`,`t`.`abreviatura` AS `turno_abreviatura`,`t`.`hora_ingreso` AS `hora_ingreso`,`t`.`hora_salida` AS `hora_salida`,`t`.`tolerancia_minutos` AS `tolerancia_minutos`,`s`.`id_nivel` AS `id_nivel`,`n`.`nombre` AS `nivel_nombre`,`s`.`id_grado` AS `id_grado`,`g`.`grado` AS `grado`,`s`.`seccion` AS `seccion`,`p`.`capacidad` AS `capacidad`,`p`.`estado` AS `estado`,count(distinct `pe`.`id_estudiante`) AS `total_estudiantes`,count(distinct `pda`.`id`) AS `total_areas` from (((((((((`programaciones` `p` left join `anios_lectivos` `an` on(`p`.`id_anio_lectivo` = `an`.`id`)) left join `docentes` `d` on(`p`.`id_tutor` = `d`.`id`)) left join `auxiliares` `a` on(`p`.`id_auxiliar` = `a`.`id`)) left join `turnos` `t` on(`p`.`id_turno` = `t`.`id`)) left join `secciones` `s` on(`p`.`id_seccion` = `s`.`id`)) left join `niveles` `n` on(`s`.`id_nivel` = `n`.`id`)) left join `grados` `g` on(`s`.`id_grado` = `g`.`id`)) left join `programaciones_estudiantes` `pe` on(`p`.`id` = `pe`.`id_programacion` and `pe`.`estado` = 'activo')) left join `programaciones_docentes_areas` `pda` on(`p`.`id` = `pda`.`id_programacion` and `pda`.`estado` = 'activo')) group by `p`.`id`;

