-- =============================================
-- SICA - Crear Usuario y Permisos en Hosting
-- =============================================
-- Ejecutar este script en phpMyAdmin o consola MySQL del hosting
-- Esto creará el usuario 'sanjose' y le dará todos los permisos

-- 1. Crear el usuario (si no existe)
-- Cambia 'tu_contraseña_segura' por una contraseña real y segura
CREATE USER IF NOT EXISTS 'sanjose'@'localhost' IDENTIFIED BY 'tu_contraseña_segura';

-- 2. Dar todos los permisos sobre la base de datos SICA2025
GRANT ALL PRIVILEGES ON SICA2025.* TO 'sanjose'@'localhost';

-- 3. Aplicar cambios
FLUSH PRIVILEGES;

-- =============================================
-- Verificar permisos (opcional)
-- =============================================
-- SHOW GRANTS FOR 'sanjose'@'localhost';

-- =============================================
-- Si el usuario ya existe, solo cambiar contraseña
-- =============================================
-- ALTER USER 'sanjose'@'localhost' IDENTIFIED BY 'tu_contraseña_segura';
-- FLUSH PRIVILEGES;
