-- ============================================
-- EJEMPLO: Configurar Vacaciones por Año Lectivo 2025
-- Fecha: 2025-12-28
-- Descripción: Ejemplo de cómo configurar vacaciones específicas para 2025
-- ============================================
--
-- ANTES DE EJECUTAR:
-- 1. Verificar que el año lectivo 2025-2026 existe
-- 2. Anotar su ID (usualmente es 1, pero puede variar)
--
-- CÓMO VERIFICAR:
-- SELECT id, anio, fecha_inicio, fecha_fin FROM anios_lectivos WHERE anio LIKE '2025%';
--
-- ============================================

-- Paso 1: Configurar fechas del año lectivo 2025-2026
-- Ajuste según el calendario escolar de su institución
UPDATE anios_lectivos
SET fecha_inicio = '2025-03-03',  -- Inicio de clases (primer lunes de marzo)
    fecha_fin = '2025-12-20'       -- Fin de clases (antes de navidad)
WHERE id = 1;  -- ← REEMPLAZAR CON EL ID CORRECTO

-- Paso 2: Verificar configuración
SELECT id, anio, fecha_inicio, fecha_fin, estado
FROM anios_lectivos
WHERE id = 1;

-- ============================================
-- NOTAS IMPORTANTES:
--
-- 1. El sistema VALIDARÁ AUTOMÁTICAMENTE las vacaciones:
--    - Si hoy < fecha_inicio → "Aún no inicia el año lectivo"
--    - Si hoy > fecha_fin → "El año lectivo ha finalizado"
--
-- 2. NO es necesario registrar TODOS los días de vacaciones en la tabla calendario
--    Solo los puntos de inflexión (inicio y fin de vacaciones)
--
-- 3. Ejemplo: Si las vacaciones de julio son del 26/07 al 24/08:
--    Solo registra esas dos fechas, el sistema detectará el rango automáticamente
--
-- ============================================

-- Paso 3 (OPCIONAL): Registrar puntos de inflexión de vacaciones
-- Nota: Esto es OPCIONAL, el sistema ya valida por fecha_inicio/fecha_fin del año lectivo

-- Vacaciones de julio 2025 (solo si desea registrar explícitamente)
-- INSERT INTO calendario (fecha, tipo, nombre, descripcion, aniolectivo_id, afecta_todos_niveles)
-- VALUES
-- ('2025-07-26', 'vacacion', 'Inicio vacaciones de julio', 'Inicio del receso de julio', 1, TRUE),
-- ('2025-08-24', 'vacacion', 'Fin vacaciones de julio', 'Reinicio de clases', 1, TRUE);

-- ============================================
-- CÓMO FUNCIONARÁ LA VALIDACIÓN:
--
-- ESCENARIO 1: Hoy es 15 de enero de 2025
-- → Sistema detecta: 2025-01-15 < 2025-03-03 (fecha_inicio)
-- → Mensaje: "Aún no inicia el año lectivo 2025-2026. Inicio de clases: 03/03/2025"
--
-- ESCENARIO 2: Hoy es 28 de julio de 2025 (Fiestas Patrias)
-- → Sistema detecta: Feriado GLOBAL (aniolectivo_id = NULL)
-- → Mensaje: "Hoy es Feriado: Fiestas Patrias - Día 1. No se registran asistencias."
--
-- ESCENARIO 3: Hoy es 30 de julio de 2025 (vacaciones de julio)
-- → Sistema detecta: Está dentro del rango del año lectivo, NO valida automáticamente
-- → Opcional: Si registraste explícitamente el inicio/fin de vacaciones, lo detectará
--
-- ESCENARIO 4: Hoy es 28 de diciembre de 2025
-- → Sistema detecta: 2025-12-28 > 2025-12-20 (fecha_fin)
-- → Mensaje: "El año lectivo 2025-2026 ha finalizado. Fin de clases: 20/12/2025"
--
-- ============================================

-- Paso 4: Verificar feriados globales configurados
SELECT
    fecha,
    tipo,
    nombre,
    CASE
        WHEN aniolectivo_id IS NULL THEN '✓ GLOBAL'
        ELSE CONCAT('Año lectivo ID: ', aniolectivo_id)
    END AS alcance
FROM calendario
WHERE estado = 'activo'
ORDER BY fecha;

-- ============================================
-- RESULTADO ESPERADO:
-- Debería ver ✓ GLOBAL junto a Año Nuevo, Fiestas Patrias, Navidad, etc.
-- Estos feriados aplicarán a TODOS los años lectivos (2025, 2026, 2027...)
-- ============================================
