-- Fix encoding issue with turno field
-- The problem: UTF-8 encoding differs between tables
-- This script ensures all tables use the same encoding

USE sica2025;

-- Step 1: Backup data
-- CREATE TABLE programaciones_backup AS SELECT * FROM programaciones;

-- Step 2: Update all records to use the same enum value (index 1 = 'mañana')
-- This forces MySQL to re-encode the value consistently

UPDATE horarios SET turno = 1 WHERE turno = 1;
UPDATE secciones SET turno = 1 WHERE turno = 1;
UPDATE programaciones SET turno = 1 WHERE turno = 1;

-- Verify they match now
SELECT
    'horarios' as tabla,
    HEX(turno) as hex_turno,
    LENGTH(turno) as length
FROM horarios LIMIT 1
UNION ALL
SELECT
    'secciones',
    HEX(turno),
    LENGTH(turno)
FROM secciones LIMIT 1
UNION ALL
SELECT
    'programaciones',
    HEX(turno),
    LENGTH(turno)
FROM programaciones LIMIT 1;
