-- ============================================
-- SICA - Fix: Sincronizar turno en programaciones
-- ============================================
-- Soluciona el problema del campo turno vacío en programaciones

USE sica2025;

-- Paso 1: Recrear el campo turno con el encoding correcto
ALTER TABLE programaciones ADD COLUMN turno_new ENUM('mañana','tarde') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci AFTER id_auxiliar;

-- Paso 2: Copiar los valores desde secciones usando el índice del enum
UPDATE programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
SET p.turno_new =
    CASE s.turno
        WHEN 'mañana' THEN 1
        WHEN 'tarde' THEN 2
    END;

-- Paso 3: Eliminar el campo viejo y renombrar el nuevo
ALTER TABLE programaciones DROP COLUMN turno;
ALTER TABLE programaciones CHANGE COLUMN turno_new turno ENUM('mañana','tarde') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- Paso 4: Verificar
SELECT
    p.id,
    s.grado,
    s.seccion,
    p.turno as turno_programacion,
    s.turno as turno_seccion,
    HEX(p.turno) as hex_p,
    HEX(s.turno) as hex_s,
    h.hora_ingreso,
    h.hora_salida
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LEFT JOIN horarios h ON h.id_nivel = s.id_nivel AND h.id_anio_lectivo = p.id_anio_lectivo AND h.turno = s.turno
LIMIT 5;
