-- ============================================
-- GENERAR FERIADOS GLOBALES PARA MÚLTIPLES AÑOS
-- Fecha: 2025-12-28
-- Descripción: Crea feriados para 2025, 2026, 2027, 2028, 2029, 2030
-- ============================================
--
-- EJECUTAR ESTE SCRIPT para tener feriados de múltiples años
-- Los feriados GLOBALES (aniolectivo_id = NULL) se repiten para cada año
--
-- ============================================

-- Primero, eliminar feriados existentes si los hay
DELETE FROM calendario WHERE aniolectivo_id IS NULL;

-- Feriados nacionales de Perú - Generar para 2025, 2026, 2027, 2028, 2029, 2030
INSERT INTO calendario (fecha, tipo, nombre, descripcion, aniolectivo_id, afecta_todos_niveles) VALUES
-- Año Nuevo (1 de enero)
('2025-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),
('2026-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),
('2027-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),
('2028-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),
('2029-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),
('2030-01-01', 'feriado', 'Año Nuevo', 'Primer día del año', NULL, TRUE),

-- Viernes Santo y Jueves Santo (fechas variables - calcular según cada año)
('2025-04-10', 'feriado', 'Jueves Santo', 'Jueves Santo (Semana Santa)', NULL, TRUE),
('2025-03-29', 'dia_no_laboral', 'Viernes Santo', 'Viernes Santo (Semana Santa)', NULL, TRUE),

('2026-04-02', 'feriado', 'Jueves Santo', 'Jueves Santo (Semana Santa)', NULL, TRUE),
('2026-03-27', 'dia_no_laboral', 'Viernes Santo', 'Viernes Santo (Semana Santa)', NULL, TRUE),

('2027-04-01', 'feriado', 'Jueves Santo', 'Jueves Santo (Semana Santa)', NULL, TRUE),
('2027-04-10', 'dia_no_laboral', 'Viernes Santo', 'Viernes Santo (Semana Santa)', NULL, TRUE),

-- Día del Trabajo (1 de mayo)
('2025-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),
('2026-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),
('2027-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),
('2028-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),
('2029-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),
('2030-05-01', 'feriado', 'Día del Trabajo', 'Feriado laboral nacional', NULL, TRUE),

-- San Pedro y San Pablo (29 de junio)
('2025-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),
('2026-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),
('2027-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),
('2028-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),
('2029-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),
('2030-06-29', 'feriado', 'San Pedro y San Pablo', 'Feriado religioso', NULL, TRUE),

-- Fiestas Patrias (28 y 29 de julio)
('2025-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2025-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

('2026-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2026-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

('2027-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2027-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

('2028-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2028-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

('2029-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2029-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

('2030-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Independencia del Perú', NULL, TRUE),
('2030-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE),

-- Santa Rosa de Lima (30 de agosto)
('2025-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),
('2026-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),
('2027-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),
('2028-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),
('2029-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),
('2030-08-30', 'feriado', 'Santa Rosa de Lima', 'Feriado religioso', NULL, TRUE),

-- Combate de Angamos (8 de octubre)
('2025-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),
('2026-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),
('2027-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),
('2028-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),
('2029-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),
('2030-10-08', 'feriado', 'Combate de Angamos', 'Feriado nacional', NULL, TRUE),

-- Todos los Santos (1 de noviembre)
('2025-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),
('2026-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),
('2027-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),
('2028-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),
('2029-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),
('2030-11-01', 'feriado', 'Todos los Santos', 'Feriado religioso', NULL, TRUE),

-- Inmaculada Concepción (8 de diciembre)
('2025-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),
('2026-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),
('2027-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),
('2028-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),
('2029-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),
('2030-12-08', 'feriado', 'Inmaculada Concepción', 'Feriado religioso', NULL, TRUE),

-- Navidad (25 de diciembre)
('2025-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE),
('2026-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE),
('2027-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE),
('2028-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE),
('2029-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE),
('2030-12-25', 'feriado', 'Navidad', 'Natividad del Señor', NULL, TRUE);

-- ============================================
-- VERIFICACIÓN
-- ============================================
--
-- Para verificar que se crearon correctamente:
--
-- SELECT YEAR(fecha) as año, COUNT(*) as total_feriados
-- FROM calendario
-- WHERE aniolectivo_id IS NULL
-- GROUP BY YEAR(fecha)
-- ORDER BY año;
--
-- Debería mostrar:
-- 2025 | 13
-- 2026 | 13
-- 2027 | 13
-- 2028 | 13
-- 2029 | 13
-- 2030 | 13
--
-- ============================================
