<?php
/**
 * Script para limpiar completamente un DNI del sistema
 * Elimina tanto de la tabla principal como de usuarios
 * Uso: limpiar_dni.php?dni=41675960&tabla=apoderados
 *
 * Tablas válidas: estudiantes, apoderados, docentes, auxiliares
 */

require_once '../config/db.php';

$dni = $_GET['dni'] ?? '';
$tabla = $_GET['tabla'] ?? '';
$confirmar = $_GET['confirmar'] ?? 'no';

if (empty($dni) || empty($tabla)) {
    die("Error: Debe especificar dni y tabla. Ejemplo: limpiar_dni.php?dni=41675960&tabla=apoderados");
}

$tablas_validas = ['estudiantes', 'apoderados', 'docentes', 'auxiliares'];
if (!in_array($tabla, $tablas_validas)) {
    die("Error: Tabla no válida. Use: estudiantes, apoderados, docentes o auxiliares");
}

// Mostrar información antes de eliminar
if ($confirmar !== 'si') {
    echo "<h2>Limpiar DNI: $dni (tabla: $tabla)</h2>";
    echo "<h3 style='color: red;'>⚠️ ADVERTENCIA: Esta acción eliminará permanentemente:</h3>";
    echo "<ul>";
    echo "<li>El registro de $tabla con DNI $dni</li>";
    echo "<li>El usuario asociado con DNI $dni</li>";
    echo "</ul>";
    echo "<h3>Información actual:</h3>";

    // Buscar en la tabla principal
    $stmt = $pdo->prepare("SELECT * FROM $tabla WHERE dni = ?");
    $stmt->execute([$dni]);
    $registro = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($registro) {
        echo "<pre>";
        print_r($registro);
        echo "</pre>";
    } else {
        echo "<p style='color: orange;'>No encontrado en tabla $tabla</p>";
    }

    // Buscar usuario
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE usuario = ?");
    $stmt->execute([$dni]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($usuario) {
        echo "<h4>Usuario asociado:</h4>";
        echo "<pre>";
        print_r($usuario);
        echo "</pre>";
    } else {
        echo "<p style='color: green;'>No hay usuario asociado</p>";
    }

    echo "<hr>";
    echo "<p><strong>Para confirmar la eliminación, haz clic en:</strong></p>";
    echo "<a href='?dni=$dni&tabla=$tabla&confirmar=si' style='background: red; color: white; padding: 15px 30px; text-decoration: none; font-size: 18px;'>🗑️ ELIMINAR DEFINITIVAMENTE</a>";
    echo "<p><a href='javascript:history.back()'>Cancelar</a></p>";
    exit;
}

// Confirmación recibida - Proceder con la eliminación
try {
    $pdo->beginTransaction();

    // 1. Buscar el registro para obtener id_usuario si existe
    $stmt = $pdo->prepare("SELECT id, id_usuario FROM $tabla WHERE dni = ?");
    $stmt->execute([$dni]);
    $registro = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$registro) {
        throw new Exception("No se encontró $tabla con DNI $dni");
    }

    $id_usuario = $registro['id_usuario'];

    // 2. Eliminar el registro de la tabla principal
    $stmt = $pdo->prepare("DELETE FROM $tabla WHERE dni = ?");
    $filas = $stmt->execute([$dni]);

    if ($filas === false || $stmt->rowCount() == 0) {
        throw new Exception("No se pudo eliminar de $tabla");
    }

    echo "✅ Eliminado de $tabla<br>";

    // 3. Eliminar el usuario si existe
    if ($id_usuario) {
        $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = ?");
        $stmt->execute([$id_usuario]);
        echo "✅ Usuario asociado eliminado (ID: $id_usuario)<br>";
    } else {
        // Si no tenía id_usuario, buscar por nombre de usuario = DNI
        $stmt = $pdo->prepare("DELETE FROM usuarios WHERE usuario = ?");
        $stmt->execute([$dni]);
        if ($stmt->rowCount() > 0) {
            echo "✅ Usuario con DNI $dni eliminado<br>";
        } else {
            echo "ℹ️ No había usuario para eliminar<br>";
        }
    }

    $pdo->commit();

    echo "<hr>";
    echo "<h3 style='color: green;'>✅ Limpieza completada con éxito</h3>";
    echo "<p>El DNI $dni ha sido completamente eliminado del sistema.</p>";
    echo "<p><a href='../index.php'>Volver al inicio</a></p>";

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    die("<h3 style='color: red;'>Error: " . $e->getMessage() . "</h3>");
}
