<?php
/**
 * Limpia archivos SQL antiguos, dejando solo el más reciente
 */

$dir = __DIR__;
$pattern = 'SICA2025_PRODUCCION_*.sql';

// Buscar archivos SQL
$files = glob($dir . '/' . $pattern);

if (count($files) <= 1) {
    echo "No hay archivos viejos para limpiar.\n";
    echo "Archivo actual: " . basename($files[0] ?? 'Ninguno') . "\n";
    exit(0);
}

// Ordenar por fecha de modificación (descendente)
usort($files, function($a, $b) {
    return filemtime($b) - filemtime($a);
});

// Mantener el primero (más reciente)
$latest = array_shift($files);
$deleted_count = 0;
$deleted_size = 0;

foreach ($files as $file) {
    $size = filesize($file);
    $gz = $file . '.gz';

    echo "Eliminando: " . basename($file) . " (" . number_format($size/1024, 2) . " KB)\n";

    if (unlink($file)) {
        $deleted_count++;
        $deleted_size += $size;
    }

    // También eliminar el .gz si existe
    if (file_exists($gz)) {
        $deleted_size += filesize($gz);
        unlink($gz);
        echo "  Eliminando: " . basename($gz) . "\n";
    }
}

echo "\n✓ Limpieza completada:\n";
echo "  - Archivos eliminados: $deleted_count\n";
echo "  - Espacio liberado: " . number_format($deleted_size/1024, 2) . " KB\n";
echo "  - Archivo mantenido: " . basename($latest) . "\n";
