-- =============================================
-- Migración: Email Único para Apoderados
-- =============================================
-- Agregar índice único para asegurar que no se repitan emails

-- 1. Verificar si ya existe el índice
-- 2. Eliminar emails duplicados si existen (mantener el más antiguo)
-- 3. Crear índice único

USE SICA2025;

-- Eliminar índice si existe
DROP INDEX IF EXISTS unique_email ON apoderados;

-- Crear índice único
ALTER TABLE apoderados
ADD UNIQUE KEY unique_email (email);

-- Nota: Si hay emails duplicados, esta consulta fallará
-- Para limpiar duplicados, ejecutar primero:

-- DELETE t1 FROM apoderados t1
-- INNER JOIN apoderados t2
-- WHERE t1.id > t2.id AND t1.email = t2.email AND t1.email IS NOT NULL AND t1.email != '';
