-- =============================================
-- Migración: Tabla de Auxiliares
-- Fecha: 2025-12-24
-- Descripción: Crear tabla para gestionar auxiliares de educación
-- =============================================

-- Crear tabla de auxiliares
CREATE TABLE IF NOT EXISTS auxiliares (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_usuario INT NOT NULL,
    dni VARCHAR(8) NOT NULL UNIQUE,
    apellido_paterno VARCHAR(100) NOT NULL,
    apellido_materno VARCHAR(100) NOT NULL,
    nombres VARCHAR(100) NOT NULL,
    email VARCHAR(100),
    telefono VARCHAR(20),
    direccion VARCHAR(255),
    fecha_nacimiento DATE,
    genero ENUM('M', 'F') DEFAULT NULL,
    estado ENUM('activo', 'inactivo', 'retirado') DEFAULT 'activo',
    fecha_registro DATETIME DEFAULT CURRENT_TIMESTAMP,

    FOREIGN KEY (id_usuario) REFERENCES usuarios(id) ON DELETE CASCADE,

    INDEX idx_dni (dni),
    INDEX idx_estado (estado),
    INDEX idx_apellidos (apellido_paterno, apellido_materno),
    INDEX idx_usuario (id_usuario)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar algunos auxiliares de prueba (con usuarios correspondientes)
-- Nota: Estos usuarios deben existir en la tabla usuarios con rol 'auxiliar'

-- Ejemplo de uso después de tener usuarios creados:
-- INSERT INTO auxiliares (id_usuario, dni, apellido_paterno, apellido_materno, nombres, email, telefono, direccion, fecha_nacimiento, genero)
-- VALUES
-- (1, '12345678', 'García', 'Lopez', 'Maria Elena', 'maria.garcia@sica.edu', '987654321', 'Av. Principal 123', '1985-03-15', 'F'),
-- (2, '23456789', 'Rodriguez', 'Martinez', 'Carlos Alberto', 'carlos.rodriguez@sica.edu', '987654322', 'Jr. Secundaria 456', '1988-07-22', 'M');
