-- Migración para agregar ON DELETE CASCADE en las relaciones con usuarios
-- Esto asegura que al eliminar un usuario, se eliminen automáticamente
-- sus registros relacionados (docentes, auxiliares, apoderados, estudiantes)

USE sica2025;

-- Eliminar foreign keys existentes
ALTER TABLE docentes DROP FOREIGN KEY IF EXISTS fk_docentes_usuario;
ALTER TABLE auxiliares DROP FOREIGN KEY IF EXISTS fk_auxiliares_usuario;
ALTER TABLE apoderados DROP FOREIGN KEY IF EXISTS fk_apoderados_usuario;
ALTER TABLE estudiantes DROP FOREIGN KEY IF EXISTS fk_estudiantes_usuario;

-- Re-crear foreign keys con ON DELETE CASCADE
ALTER TABLE docentes
ADD CONSTRAINT fk_docentes_usuario
FOREIGN KEY (id_usuario) REFERENCES usuarios(id)
ON DELETE CASCADE;

ALTER TABLE auxiliares
ADD CONSTRAINT fk_auxiliares_usuario
FOREIGN KEY (id_usuario) REFERENCES usuarios(id)
ON DELETE CASCADE;

ALTER TABLE apoderados
ADD CONSTRAINT fk_apoderados_usuario
FOREIGN KEY (id_usuario) REFERENCES usuarios(id)
ON DELETE CASCADE;

ALTER TABLE estudiantes
ADD CONSTRAINT fk_estudiantes_usuario
FOREIGN KEY (id_usuario) REFERENCES usuarios(id)
ON DELETE CASCADE;

-- Verificar las restricciones
SELECT
    TABLE_NAME,
    CONSTRAINT_NAME,
    REFERENCED_TABLE_NAME,
    DELETE_RULE
FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
WHERE TABLE_SCHEMA = 'sica2025'
AND REFERENCED_TABLE_NAME = 'usuarios';
