-- ============================================
-- MIGRACIÓN: Tabla estados_asistencia
-- Fecha: 2025-12-28
-- Descripción: Catálogo de estados para registros de asistencia
-- ============================================

-- Crear tabla estados_asistencia
CREATE TABLE IF NOT EXISTS estados_asistencia (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(50) NOT NULL UNIQUE,
    abreviatura VARCHAR(10) NOT NULL UNIQUE,
    descripcion TEXT,
    color VARCHAR(20) DEFAULT '#6c757d',  -- Color hex para badges (Bootstrap)
    icono VARCHAR(50) DEFAULT 'circle-fill',  -- Icono de Bootstrap Icons
    conteo_asistencia ENUM('si', 'no') DEFAULT 'si',  -- Si cuenta como presente (sí/no)
    permite_tardanza BOOLEAN DEFAULT FALSE,  -- Si permite registro de minutos de tardanza
    requiere_justificacion BOOLEAN DEFAULT FALSE,  -- Si requiere justificación/documento
    estado ENUM('activo', 'inactivo') DEFAULT 'activo',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_estado (estado),
    INDEX idx_conteo_asistencia (conteo_asistencia)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- DATOS INICIALES
-- ============================================

-- Estados de asistencia principales
INSERT INTO estados_asistencia (nombre, abreviatura, descripcion, color, icono, conteo_asistencia, permite_tardanza, requiere_justificacion) VALUES
('Asistencia', 'ASI', 'Estudiante presente a tiempo', '#10b981', 'check-circle-fill', 'si', FALSE, FALSE),
('Tardanza', 'TAR', 'Llegó después de la hora de entrada con tolerancia', '#f59e0b', 'clock-fill', 'si', TRUE, FALSE),
('Tardanza Justificada', 'TJU', 'Tardanza con justificación documentada', '#3b82f6', 'clock-history', 'si', TRUE, TRUE),
('Falta Injustificada', 'FIN', 'Ausencia sin justificación', '#ef4444', 'x-circle-fill', 'no', FALSE, FALSE),
('Falta Justificada', 'FJU', 'Ausencia con justificación documentada (médica, etc.)', '#8b5cf6', 'file-check-fill', 'no', FALSE, TRUE),
('Excusado', 'EXC', 'Estudiante excusado por la institución (viaje, competencia, etc.)', '#06b6d4', 'shield-check', 'no', FALSE, TRUE),
('Licencia', 'LIC', 'Licencia médica o autorización prolongada', '#ec4899', 'calendar-check', 'no', FALSE, TRUE);

-- ============================================
-- NOTAS DE MIGRACIÓN
-- ============================================
--
-- Esta tabla permitirá:
-- 1. Centralizar la configuración de estados de asistencia
-- 2. Personalizar colores e iconos para la UI
-- 3. Definir qué estados cuentan como asistencia
-- 4. Controlar cuáles requieren justificación
-- 5. Flexibilidad para agregar nuevos estados según necesidades
--
-- La tabla `asistencias` se actualizará posteriormente para usar FK a esta tabla.
--
-- ============================================
