-- ============================================
-- MIGRACIÓN: Agregar tabla grados
-- Este script modifica la estructura para tener grados individuales
-- ============================================

USE SICA2025;

-- ============================================
-- NUEVA TABLA: grados (grados individuales por nivel)
-- ============================================
CREATE TABLE IF NOT EXISTS grados (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_nivel INT NOT NULL,
    id_anio_lectivo INT NOT NULL,
    grado VARCHAR(50) NOT NULL, -- 1°, 2°, 3°, 3 años, 4 años, 5 años, etc.
    estado ENUM('activo', 'inactivo') DEFAULT 'activo',
    INDEX idx_nivel_anio (id_nivel, id_anio_lectivo),
    FOREIGN KEY (id_nivel) REFERENCES niveles(id),
    FOREIGN KEY (id_anio_lectivo) REFERENCES anios_lectivos(id)
);

-- Actualizar tabla secciones para que referencie a grados
ALTER TABLE secciones ADD COLUMN IF NOT EXISTS id_grado INT AFTER id_nivel;

-- ============================================
-- DATOS DE EJEMPLO PARA GRADOS
-- ============================================

-- Inicial: 3 años, 4 años, 5 años
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 1, id, '3 años' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 1, id, '4 años' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 1, id, '5 años' FROM anios_lectivos WHERE estado = 'activo';

-- Primaria: 6 grados (1° a 6°)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '1°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '2°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '3°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '4°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '5°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 2, id, '6°' FROM anios_lectivos WHERE estado = 'activo';

-- Secundaria: 5 grados (1° a 5°)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 3, id, '1°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 3, id, '2°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 3, id, '3°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 3, id, '4°' FROM anios_lectivos WHERE estado = 'activo';
INSERT INTO grados (id_nivel, id_anio_lectivo, grado)
SELECT 3, id, '5°' FROM anios_lectivos WHERE estado = 'activo';
