-- ============================================
-- MIGRACIÓN: Tabla de notificaciones
-- Fecha: 2025-12-28
-- Descripción: Sistema de notificaciones para apoderados sobre inasistencias
-- ============================================

-- Crear tabla notificaciones
CREATE TABLE IF NOT EXISTS notificaciones (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_apoderado INT NOT NULL,
    id_estudiante INT NOT NULL,
    tipo ENUM('inasistencia', 'tardanza', 'falta_repetida', 'alerta') DEFAULT 'inasistencia',
    titulo VARCHAR(200) NOT NULL,
    mensaje TEXT NOT NULL,
    fecha_notificacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    leida BOOLEAN DEFAULT FALSE,
    fecha_lectura DATETIME NULL,
    email_enviado BOOLEAN DEFAULT FALSE,
    fecha_email DATETIME NULL,
    id_anio_lectivo INT NOT NULL,
    estado ENUM('activo', 'archivado') DEFAULT 'activo',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_apoderado (id_apoderado),
    INDEX idx_estudiante (id_estudiante),
    INDEX idx_leida (leida),
    INDEX idx_fecha (fecha_notificacion),
    INDEX idx_tipo (tipo),
    FOREIGN KEY (id_apoderado) REFERENCES apoderados(id) ON DELETE CASCADE,
    FOREIGN KEY (id_estudiante) REFERENCES estudiantes(id) ON DELETE CASCADE,
    FOREIGN KEY (id_anio_lectivo) REFERENCES anios_lectivos(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- NOTAS DE MIGRACIÓN
-- ============================================
--
-- Esta tabla permitirá:
-- 1. Registrar notificaciones de inasistencias automáticamente
-- 2. Marcar como leídas/no leídas por el apoderado
-- 3. Controlar envío de correos electrónicos
-- 4. Mantener historial de todas las notificaciones enviadas
--
-- El script programado verificará cada X minutos:
-- - Estudiantes sin asistencia hoy
-- - Que haya pasado el tiempo configurado desde su hora de ingreso
-- - Creará notificación en el sistema
-- - Enviará correo electrónico al apoderado
--
-- ============================================
