-- ============================================
-- SICA - Migración Final: Eliminar campos viejos de turno
-- ============================================
-- Este script elimina los campos ENUM 'turno' de las tablas
-- secciones y programaciones, dejando solo id_turno (FK a turnos)

USE sica2025;

-- Verificar antes de eliminar
SELECT 'ANTES DE ELIMINAR - Secciones:' as info;
SELECT
    id,
    grado,
    seccion,
    turno as turno_viejo,
    id_turno,
    (SELECT nombre FROM turnos WHERE id = id_turno) as turno_nuevo
FROM secciones
LIMIT 3;

SELECT 'ANTES DE ELIMINAR - Programaciones:' as info;
SELECT
    p.id,
    s.grado,
    s.seccion,
    p.turno as turno_viejo,
    p.id_turno,
    (SELECT nombre FROM turnos WHERE id = p.id_turno) as turno_nuevo
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LIMIT 3;

-- Verificar que todos los registros tienen id_turno asignado
SELECT 'Registros de secciones SIN id_turno:' as check_info;
SELECT COUNT(*) as total FROM secciones WHERE id_turno IS NULL;

SELECT 'Registros de programaciones SIN id_turno:' as check_info;
SELECT COUNT(*) as total FROM programaciones WHERE id_turno IS NULL;

-- ELIMINAR campos viejos (solo ejecutar si los counts anteriores son 0)
-- Si hay registros con id_turno NULL, primero asignar un valor por defecto

-- Para secciones sin id_turno, asignar turno por defecto (1 = Mañana)
UPDATE secciones SET id_turno = 1 WHERE id_turno IS NULL;

-- Para programaciones sin id_turno, asignar el mismo turno que su sección
UPDATE programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
SET p.id_turno = s.id_turno
WHERE p.id_turno IS NULL;

-- Ahora eliminar los campos viejos
ALTER TABLE secciones DROP COLUMN turno;
ALTER TABLE programaciones DROP COLUMN turno;

-- Verificar después de eliminar
SELECT 'DESPUÉS DE ELIMINAR - Estructura de secciones:' as info;
DESCRIBE secciones;

SELECT 'DESPUÉS DE ELIMINAR - Estructura de programaciones:' as info;
DESCRIBE programaciones;

-- Verificación final
SELECT 'VERIFICACIÓN FINAL - Secciones:' as info;
SELECT
    s.id,
    s.grado,
    s.seccion,
    s.id_turno,
    t.nombre as turno,
    t.hora_ingreso,
    t.hora_salida
FROM secciones s
INNER JOIN turnos t ON t.id = s.id_turno
LIMIT 3;

SELECT 'VERIFICACIÓN FINAL - Programaciones:' as info;
SELECT
    p.id,
    s.grado,
    s.seccion,
    p.id_turno,
    t.nombre as turno,
    t.hora_ingreso,
    t.hora_salida
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
INNER JOIN turnos t ON t.id = p.id_turno
LIMIT 3;
