<?php
// Script rápido de diagnóstico
require_once 'config/db.php';

echo "<pre>";
echo "=== DIAGNÓSTICO DE BASE DE DATOS ===\n\n";

// Verificar estructura de auxiliares
echo "1. ESTRUCTURA DE TABLA AUXILIARES:\n";
echo "-----------------------------------\n";
try {
    $stmt = $pdo->query("DESCRIBE auxiliares");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo sprintf("%-20s %-30s %-10s\n", $row['Field'], $row['Type'], $row['Null']);
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// Verificar estructura de tipos_incidencia
echo "2. ESTRUCTURA DE TABLA TIPOS_INCIDENCIA:\n";
echo "-----------------------------------------\n";
try {
    $stmt = $pdo->query("DESCRIBE tipos_incidencia");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo sprintf("%-25s %-30s %-10s\n", $row['Field'], $row['Type'], $row['Null']);
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// Verificar datos de auxiliares
echo "3. DATOS DE AUXILIARES:\n";
echo "----------------------\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM auxiliares");
    echo "Total auxiliares: " . $stmt->fetch()['total'] . "\n";

    $stmt = $pdo->query("SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre, a.id_turno FROM auxiliares a LIMIT 1");
    $aux = $stmt->fetch();
    if ($aux) {
        echo "Auxiliar de prueba: ID={$aux['id']}, DNI={$aux['dni']}, Nombre={$aux['nombre']}, id_turno=" . ($aux['id_turno'] ?? 'NULL') . "\n";
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// Verificar datos de tipos_incidencia
echo "4. DATOS DE TIPOS_INCIDENCIA:\n";
echo "------------------------------\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM tipos_incidencia");
    echo "Total tipos_incidencia: " . $stmt->fetch()['total'] . "\n";

    $stmt = $pdo->query("SELECT tipo, puntos_penalidad FROM tipos_incidencia LIMIT 3");
    while ($row = $stmt->fetch()) {
        echo sprintf("- %-30s: %d puntos\n", $row['tipo'], (int)$row['puntos_penalidad']);
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// Probar consulta de auxiliares/index.php
echo "5. PRUEBA DE CONSULTA AUXILIARES/INDEX.PHP:\n";
echo "----------------------------------------------\n";
try {
    $sql = "SELECT a.*, u.usuario, u.ultimo_acceso, t.nombre as turno, t.abreviatura as turno_abrev
            FROM auxiliares a
            INNER JOIN usuarios u ON a.id_usuario = u.id
            LEFT JOIN turnos t ON t.id = a.id_turno
            WHERE 1=1
            ORDER BY a.apellido_paterno, a.apellido_materno, a.nombres";

    $stmt = $pdo->query($sql);
    $total = $stmt->rowCount();
    echo "✓ Consulta ejecutada correctamente\n";
    echo "✓ Total registros: $total\n";

    if ($total > 0) {
        $row = $stmt->fetch();
        echo "✓ Primer registro: " . $row['apellido_paterno'] . " " . $row['nombres'] . "\n";
    }
} catch (Exception $e) {
    echo "✗ ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";
echo "</pre>";
?>
