<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$mensaje = '';
$tipo_mensaje = '';
$errores = [];
$registros_procesados = 0;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Importar Docentes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .drop-zone {
            border: 3px dashed #cbd5e0;
            border-radius: 10px;
            padding: 40px;
            text-align: center;
            transition: all 0.3s ease;
            cursor: pointer;
            background: #f8f9fa;
        }
        .drop-zone:hover, .drop-zone.dragover {
            border-color: #4f46e5;
            background: #eef2ff;
        }
        .drop-zone i {
            font-size: 4rem;
            color: #4f46e5;
        }
    </style>
</head>
<body>
    <nav class="sidebar">
        <?php include '../includes/sidebar.php'; ?>
    </nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Importar Docentes</h3>
                <p class="text-muted mb-0">Carga masiva de docentes desde archivo Excel</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Volver
            </a>
        </div>

        <?php if ($mensaje): ?>
            <div class="alert alert-<?= $tipo_mensaje ?> alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($mensaje) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-file-earmark-excel"></i> Seleccionar Archivo</h5>
                    </div>
                    <div class="card-body">
                        <form action="procesar_importacion.php" method="POST" enctype="multipart/form-data" id="importForm">
                            <div class="drop-zone" id="dropZone">
                                <i class="bi bi-file-earmark-spreadsheet"></i>
                                <h4 class="mt-3">Arrastra tu archivo Excel aquí</h4>
                                <p class="text-muted">o haz clic para seleccionar</p>
                                <input type="file" name="archivo" id="archivo" accept=".xlsx" hidden required>
                                <div id="fileInfo" class="mt-3" style="display:none;">
                                    <span class="badge bg-success fs-6" id="fileName"></span>
                                </div>
                            </div>

                            <div class="alert alert-info mt-3">
                                <i class="bi bi-info-circle"></i>
                                <strong>Formato aceptado:</strong> Solo archivos .xlsx (Excel 2007+)
                            </div>

                            <div class="d-grid gap-2 mt-4">
                                <button type="submit" class="btn btn-primary btn-lg" id="btnImportar" disabled>
                                    <i class="bi bi-upload"></i> Importar Docentes
                                </button>
                                <a href="index.php" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Cancelar
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-3">
                    <div class="card-header bg-success text-white">
                        <h6 class="mb-0"><i class="bi bi-download"></i> Descargar Plantilla</h6>
                    </div>
                    <div class="card-body text-center">
                        <p class="text-muted mb-3">Descarga la plantilla de Excel para importar docentes correctamente</p>
                        <a href="plantilla.php" class="btn btn-success">
                            <i class="bi bi-file-earmark-excel"></i> Descargar Plantilla
                        </a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-warning">
                        <h6 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Instrucciones</h6>
                    </div>
                    <div class="card-body">
                        <ol class="small text-muted mb-0">
                            <li>Descarga la plantilla de Excel</li>
                            <li>Completa los datos obligatorios (*)
                                <ul>
                                    <li>DNI (8 dígitos)</li>
                                    <li>Apellidos</li>
                                    <li>Nombres</li>
                                </ul>
                            </li>
                            <li>Guarda el archivo en formato .xlsx</li>
                            <li>Importa el archivo</li>
                        </ol>
                        <hr>
                        <p class="small text-muted mb-0">
                            <strong>Nota:</strong> Se crearán usuarios automáticamente con:
                        </p>
                        <ul class="small text-muted mb-0">
                            <li>Usuario: DNI</li>
                            <li>Contraseña: DNI</li>
                            <li>Rol: Docente</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="bi bi-table"></i> Estructura del Archivo Excel</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm">
                        <thead class="table-light">
                            <tr>
                                <th>DNI *</th>
                                <th>Apellido Paterno *</th>
                                <th>Apellido Materno *</th>
                                <th>Nombres *</th>
                                <th>Email</th>
                                <th>Teléfono</th>
                                <th>Dirección</th>
                                <th>Fecha Nacimiento</th>
                                <th>Género</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>12345678</td>
                                <td>García</td>
                                <td>López</td>
                                <td>Maria Elena</td>
                                <td>maria@email.com</td>
                                <td>987654321</td>
                                <td>Av. Principal 123</td>
                                <td>15/03/1985</td>
                                <td>F</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <p class="small text-muted mb-0">
                    <strong>Formato de fecha:</strong> dd/mm/aaaa (ej: 15/03/1985) |
                    <strong>Género:</strong> M o F |
                    <strong>Campos con *</strong> son obligatorios
                </p>
            </div>
        </div>
    </div>

    <script>
        const dropZone = document.getElementById('dropZone');
        const fileInput = document.getElementById('archivo');
        const fileInfo = document.getElementById('fileInfo');
        const fileName = document.getElementById('fileName');
        const btnImportar = document.getElementById('btnImportar');

        // Click en drop zone abre el selector de archivos
        dropZone.addEventListener('click', () => fileInput.click());

        // Drag and drop
        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('dragover');
        });

        dropZone.addEventListener('dragleave', () => {
            dropZone.classList.remove('dragover');
        });

        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('dragover');

            const files = e.dataTransfer.files;
            if (files.length > 0) {
                fileInput.files = files;
                handleFile(files[0]);
            }
        });

        // Manejar selección de archivo
        fileInput.addEventListener('change', (e) => {
            if (e.target.files.length > 0) {
                handleFile(e.target.files[0]);
            }
        });

        function handleFile(file) {
            // Validar extensión
            const validExtensions = ['.xlsx'];
            const fileExtension = '.' + file.name.split('.').pop().toLowerCase();

            if (!validExtensions.includes(fileExtension)) {
                alert('Solo se permiten archivos .xlsx (Excel)');
                fileInput.value = '';
                fileInfo.style.display = 'none';
                btnImportar.disabled = true;
                return;
            }

            // Mostrar información del archivo
            fileName.textContent = file.name;
            fileInfo.style.display = 'block';
            btnImportar.disabled = false;
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
