<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$errores = [];
$exito = false;
$estudiantes_creados = 0;
$estudiantes_errores = [];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Importar Estudiantes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .upload-area {
            border: 3px dashed #cbd5e1;
            border-radius: 15px;
            padding: 50px;
            text-align: center;
            background-color: #f8fafc;
            transition: all 0.3s;
            cursor: pointer;
        }
        .upload-area:hover, .upload-area.dragover {
            border-color: var(--primary-color);
            background-color: #eff6ff;
        }
        .upload-area i {
            font-size: 4rem;
            color: #94a3b8;
        }
        .file-info {
            display: none;
            margin-top: 20px;
            padding: 15px;
            background-color: #ecfdf5;
            border-radius: 10px;
        }
        .btn-import {
            background: linear-gradient(135deg, #10b981, #059669);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
            color: white;
        }
        .btn-import:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.3);
            color: white;
        }
        .template-info {
            background: linear-gradient(135deg, #fef3c7, #fde68a);
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .processing-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        .processing-content {
            background: white;
            padding: 40px;
            border-radius: 15px;
            text-align: center;
        }
        .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #e2e8f0;
            border-top-color: var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <nav class="sidebar">
        <?php include '../includes/sidebar.php'; ?>
    </nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Importar Estudiantes</h3>
                <p class="text-muted mb-0">Carga masiva desde archivo Excel (XLSX)</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver
            </a>
        </div>

        <div class="content-card">
            <div class="template-info">
                <h5><i class="bi bi-info-circle me-2"></i>Instrucciones</h5>
                <ul class="mb-0">
                    <li>Descargue la <strong>plantilla de Excel</strong> con el formato correcto</li>
                    <li>Complete los datos obligatorios (*): DNI, Apellido Paterno, Apellido Materno, Nombres, Fecha Nacimiento, Género</li>
                    <li>Campos opcionales: Teléfono, Dirección</li>
                    <li>El DNI del estudiante se usará como <strong>usuario</strong> y <strong>contraseña por defecto</strong></li>
                    <li>Se generará automáticamente un <strong>código QR</strong> para cada estudiante</li>
                    <li>La asignación académica (nivel, grado, sección) y el apoderado se gestionarán en módulos separados</li>
                    <li>Cargue el archivo Excel (XLSX) y procese la importación</li>
                </ul>
                <a href="plantilla.php" class="btn btn-sm btn-warning mt-2">
                    <i class="bi bi-file-earmark-excel me-2"></i>Descargar Plantilla Excel
                </a>
            </div>

            <form id="formImportar" enctype="multipart/form-data">
                <div class="upload-area" id="uploadArea">
                    <i class="bi bi-file-earmark-excel"></i>
                    <h4 class="mt-3">Arrastre su archivo Excel aquí</h4>
                    <p class="text-muted">Formato: .xlsx (Excel 2007+)</p>
                    <input type="file" name="archivo" id="archivoInput" accept=".xlsx" style="display: none;" required>
                    <button type="button" class="btn btn-outline-primary" onclick="document.getElementById('archivoInput').click()">
                        <i class="bi bi-folder2-open me-2"></i>Seleccionar Archivo
                    </button>
                </div>

                <div class="file-info" id="fileInfo">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-file-earmark-excel text-success fs-1 me-3"></i>
                        <div>
                            <h5 class="mb-1" id="fileName"></h5>
                            <p class="text-muted mb-0" id="fileSize"></p>
                        </div>
                    </div>
                </div>

                <div class="d-flex gap-2 mt-4">
                    <button type="submit" class="btn btn-import" id="btnProcesar" disabled>
                        <i class="bi bi-upload me-2"></i>Procesar Importación
                    </button>
                    <a href="index.php" class="btn btn-outline-secondary">Cancelar</a>
                </div>
            </form>

            <?php if ($exito): ?>
                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle-fill me-2"></i>
                    <strong>Importación completada</strong>
                    <p class="mb-0">Estudiantes creados: <?= $estudiantes_creados ?></p>
                </div>
            <?php endif; ?>

            <?php if (!empty($estudiantes_errores)): ?>
                <div class="alert alert-warning mt-4">
                    <strong>Errores encontrados:</strong>
                    <ul class="mb-0">
                        <?php foreach ($estudiantes_errores as $error): ?>
                            <li><?= htmlspecialchars($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="processing-overlay" id="processingOverlay">
        <div class="processing-content">
            <div class="spinner"></div>
            <h5>Procesando importación...</h5>
            <p class="text-muted">Esto puede tomar unos segundos</p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const uploadArea = document.getElementById('uploadArea');
        const archivoInput = document.getElementById('archivoInput');
        const fileInfo = document.getElementById('fileInfo');
        const fileName = document.getElementById('fileName');
        const fileSize = document.getElementById('fileSize');
        const btnProcesar = document.getElementById('btnProcesar');
        const processingOverlay = document.getElementById('processingOverlay');

        // Drag and drop
        uploadArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            uploadArea.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', () => {
            uploadArea.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', (e) => {
            e.preventDefault();
            uploadArea.classList.remove('dragover');
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                const file = files[0];
                if (file.name.endsWith('.xlsx')) {
                    archivoInput.files = files;
                    showFileInfo(file);
                } else {
                    alert('Solo se permiten archivos Excel (.xlsx)');
                }
            }
        });

        uploadArea.addEventListener('click', () => {
            archivoInput.click();
        });

        archivoInput.addEventListener('change', (e) => {
            if (e.target.files.length > 0) {
                showFileInfo(e.target.files[0]);
            }
        });

        function showFileInfo(file) {
            fileInfo.style.display = 'block';
            fileName.textContent = file.name;
            fileSize.textContent = formatFileSize(file.size);
            btnProcesar.disabled = false;
        }

        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
        }

        document.getElementById('formImportar').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);

            processingOverlay.style.display = 'flex';

            fetch('procesar_importacion.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                processingOverlay.style.display = 'none';

                if (data.success) {
                    let mensaje = 'Importación completada exitosamente.\n\n';
                    mensaje += 'Estudiantes creados: ' + data.creados + '\n';

                    if (data.errores && data.errores.length > 0) {
                        mensaje += '\nErrores encontrados: ' + data.errores.length;
                    }

                    alert(mensaje);

                    if (data.errores && data.errores.length > 0) {
                        // Mostrar errores
                        let errorHtml = '<div class="alert alert-warning mt-4"><strong>Errores:</strong><ul>';
                        data.errores.forEach(err => {
                            errorHtml += '<li>' + err + '</li>';
                        });
                        errorHtml += '</ul></div>';
                        document.querySelector('.content-card').insertAdjacentHTML('beforeend', errorHtml);
                    } else {
                        window.location.href = 'index.php';
                    }
                } else {
                    alert('Error: ' + data.mensaje);
                }
            })
            .catch(error => {
                processingOverlay.style.display = 'none';
                alert('Error al procesar la importación: ' + error);
            });
        });
    </script>
</body>
</html>
