<?php
// Verificar que la sesión esté iniciada
if (!estaAutenticado()) {
    header('Location: /SICA/login.php');
    exit;
}

$usuario_rol = $_SESSION['usuario_rol'] ?? '';
$usuario = $_SESSION['usuario'] ?? '';

// Detectar si estamos en una página de configuración
$pagina_actual = $_SERVER['PHP_SELF'] ?? '';
$en_configuracion = strpos($pagina_actual, '/config/') !== false;
$es_index_config = basename($pagina_actual) == 'index.php' && strpos($pagina_actual, '/config/') !== false;

// Detectar módulos de gestión
$en_estudiantes = strpos($pagina_actual, '/estudiantes/') !== false;
$en_docentes = strpos($pagina_actual, '/docentes/') !== false;
$en_auxiliares = strpos($pagina_actual, '/auxiliares/') !== false;
$en_apoderados = strpos($pagina_actual, '/apoderados/') !== false;
$en_programaciones = strpos($pagina_actual, '/programaciones/') !== false;
$es_index_programaciones = basename($pagina_actual) == 'index.php' && strpos($pagina_actual, '/programaciones/') !== false;
$en_asistencias = strpos($pagina_actual, '/asistencias/') !== false;
$en_reportes = strpos($pagina_actual, '/reportes/') !== false;
?>

<div class="sidebar-header">
    <h3><i class="bi bi-mortarboard-fill"></i> SICA</h3>
    <p>Sistema Integrado de Convivencia y Asistencia</p>
</div>

<!-- Selector de Año Lectivo -->
<?php
$anio_seleccionado = getAnioLectivoSeleccionado();
$anios_disponibles = query("SELECT id, anio, estado FROM anios_lectivos ORDER BY anio DESC")->fetchAll();
$info_anio = getInfoAnioLectivoSeleccionado();
?>
<div class="sidebar-anio-selector">
    <label>Año Lectivo</label>
    <?php if (!empty($anios_disponibles)): ?>
        <select class="form-select form-select-sm" id="anioLectivoSelect">
            <?php foreach ($anios_disponibles as $anio): ?>
                <?php
                $label = htmlspecialchars($anio['anio']);
                // La estrella se basa en el año seleccionado en sesión, no en el estado de BD
                if ($anio['id'] == $anio_seleccionado) {
                    $label .= ' ★';
                }
                ?>
                <option value="<?= $anio['id'] ?>" <?= $anio_seleccionado == $anio['id'] ? 'selected' : '' ?>>
                    <?= $label ?>
                </option>
            <?php endforeach; ?>
        </select>
    <?php else: ?>
        <div class="alert alert-warning small py-2 mb-0">
            <i class="bi bi-exclamation-triangle me-1"></i>
            Sin años configurados
        </div>
    <?php endif; ?>
</div>

<div class="sidebar-user">
    <div class="user-avatar">
        <i class="bi bi-person-fill"></i>
    </div>
    <div class="text-center">
        <div class="fw-bold"><?= htmlspecialchars($usuario) ?></div>
        <div class="small opacity-75"><?= nombreRol($usuario_rol) ?></div>
    </div>
</div>

<div class="sidebar-menu">
    <?php if ($usuario_rol === 'admin'): ?>
        <div class="menu-label">Principal</div>
        <a href="/SICA/dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>

        <div class="menu-label">Configuración</div>
        <a href="#submenu-config" class="has-submenu <?= $en_configuracion && !$es_index_config ? 'active' : '' ?>" data-bs-toggle="collapse" role="button" aria-expanded="<?= $en_configuracion && !$es_index_config ? 'true' : 'false' ?>">
            <i class="bi bi-gear-fill"></i> Configuración
            <i class="bi bi-chevron-right submenu-arrow float-end mt-1"></i>
        </a>
        <div id="submenu-config" class="sidebar-submenu collapse <?= $en_configuracion && !$es_index_config ? 'show' : '' ?>">
            <a href="/SICA/config/anios_lectivos.php" class="<?= basename($pagina_actual) == 'anios_lectivos.php' ? 'active' : '' ?>"><i class="bi bi-calendar-range me-2"></i>Años Lectivos</a>
            <a href="/SICA/config/niveles.php" class="<?= basename($pagina_actual) == 'niveles.php' ? 'active' : '' ?>"><i class="bi bi-layers-fill me-2"></i>Niveles Educativos</a>
            <a href="/SICA/config/grados.php" class="<?= basename($pagina_actual) == 'grados.php' ? 'active' : '' ?>"><i class="bi bi-sort-numeric-up me-2"></i>Grados</a>
            <a href="/SICA/config/secciones.php" class="<?= basename($pagina_actual) == 'secciones.php' ? 'active' : '' ?>"><i class="bi bi-grid-3x3-gap me-2"></i>Secciones</a>
            <a href="/SICA/config/turnos.php" class="<?= basename($pagina_actual) == 'turnos.php' ? 'active' : '' ?>"><i class="bi bi-sun-fill me-2"></i>Turnos</a>
            <a href="/SICA/config/areas_academicas.php" class="<?= basename($pagina_actual) == 'areas_academicas.php' ? 'active' : '' ?>"><i class="bi bi-bookmarks me-2"></i>Áreas Académicas</a>
            <a href="/SICA/config/horarios.php" class="<?= basename($pagina_actual) == 'horarios.php' ? 'active' : '' ?>"><i class="bi bi-clock-fill me-2"></i>Horarios</a>
            <a href="/SICA/config/usuarios.php" class="<?= basename($pagina_actual) == 'usuarios.php' ? 'active' : '' ?>"><i class="bi bi-people-fill me-2"></i>Usuarios del Sistema</a>
            <a href="/SICA/config/tipos_incidencia.php" class="<?= basename($pagina_actual) == 'tipos_incidencia.php' ? 'active' : '' ?>"><i class="bi bi-exclamation-triangle-fill me-2"></i>Tipos de Incidencia</a>
            <a href="/SICA/config/estados_asistencia.php" class="<?= basename($pagina_actual) == 'estados_asistencia.php' ? 'active' : '' ?>"><i class="bi bi-clipboard-check me-2"></i>Estados de Asistencia</a>
            <a href="/SICA/config/calendario.php" class="<?= basename($pagina_actual) == 'calendario.php' ? 'active' : '' ?>"><i class="bi bi-calendar-event me-2"></i>Calendario</a>
            <a href="/SICA/config/parametros.php" class="<?= basename($pagina_actual) == 'parametros.php' ? 'active' : '' ?>"><i class="bi bi-sliders me-2"></i>Parámetros del Sistema</a>
        </div>

        <div class="menu-label">Gestión de Personas</div>
        <a href="/SICA/estudiantes/" class="<?= $en_estudiantes ? 'active' : '' ?>"><i class="bi bi-backpack-fill"></i> Estudiantes</a>
        <a href="/SICA/docentes/" class="<?= $en_docentes ? 'active' : '' ?>"><i class="bi bi-person-workspace"></i> Docentes</a>
        <a href="/SICA/auxiliares/" class="<?= $en_auxiliares ? 'active' : '' ?>"><i class="bi bi-clipboard-data-fill"></i> Auxiliares</a>
        <a href="/SICA/apoderados/" class="<?= $en_apoderados ? 'active' : '' ?>"><i class="bi bi-person-hearts"></i> Apoderados</a>

        <div class="menu-label">Operaciones</div>
        <a href="/SICA/programaciones/" class="<?= $en_programaciones ? 'active' : '' ?>"><i class="bi bi-calendar-week-fill"></i> Programaciones</a>
        <a href="#submenu-asistencias" class="has-submenu <?= $en_asistencias && !in_array(basename($pagina_actual), ['index.php', 'escanear_qr.php', 'registrar_manual.php']) ? 'active' : '' ?>" data-bs-toggle="collapse" role="button" aria-expanded="<?= $en_asistencias && !in_array(basename($pagina_actual), ['index.php', 'escanear_qr.php', 'registrar_manual.php']) ? 'true' : 'false' ?>">
            <i class="bi bi-calendar-check-fill"></i> Asistencias
            <i class="bi bi-chevron-right submenu-arrow float-end mt-1"></i>
        </a>
        <div id="submenu-asistencias" class="sidebar-submenu collapse <?= $en_asistencias && !in_array(basename($pagina_actual), ['index.php', 'escanear_qr.php', 'registrar_manual.php']) ? 'show' : '' ?>">
            <a href="/SICA/asistencias/" class="<?= basename($pagina_actual) == 'index.php' ? 'active' : '' ?>"><i class="bi bi-people-fill me-2"></i>Registro Grupal</a>
            <a href="/SICA/asistencias/escanear_qr.php" class="<?= basename($pagina_actual) == 'escanear_qr.php' ? 'active' : '' ?>"><i class="bi bi-qr-code-scan me-2"></i>Escáner QR</a>
            <a href="/SICA/asistencias/registrar_manual.php" class="<?= basename($pagina_actual) == 'registrar_manual.php' ? 'active' : '' ?>"><i class="bi bi-pencil-fill me-2"></i>Registro Individual</a>
        </div>
        <a href="/SICA/incidencias/registrar.php"><i class="bi bi-plus-circle-fill"></i> Registrar Incidencia</a>
        <a href="/SICA/incidencias/"><i class="bi bi-exclamation-triangle-fill"></i> Incidencias</a>

        <div class="menu-label">Reportes</div>
        <a href="#submenu-reportes" class="has-submenu <?= $en_reportes && basename($pagina_actual) != 'index.php' ? 'active' : '' ?>" data-bs-toggle="collapse" role="button" aria-expanded="<?= $en_reportes && basename($pagina_actual) != 'index.php' ? 'true' : 'false' ?>">
            <i class="bi bi-file-earmark-bar-graph-fill"></i> Reportes
            <i class="bi bi-chevron-right submenu-arrow float-end mt-1"></i>
        </a>
        <div id="submenu-reportes" class="sidebar-submenu collapse <?= $en_reportes && basename($pagina_actual) != 'index.php' ? 'show' : '' ?>">
            <a href="/SICA/reportes/asistencias.php" class="<?= basename($pagina_actual) == 'asistencias.php' ? 'active' : '' ?>"><i class="bi bi-calendar-check me-2"></i>Asistencias</a>
            <a href="/SICA/reportes/incidencias.php" class="<?= basename($pagina_actual) == 'incidencias.php' ? 'active' : '' ?>"><i class="bi bi-exclamation-triangle me-2"></i>Incidencias</a>
            <a href="/SICA/reportes/alertas.php" class="<?= basename($pagina_actual) == 'alertas.php' ? 'active' : '' ?>"><i class="bi bi-bell me-2"></i>Alertas</a>
            <a href="/SICA/reportes/secciones.php" class="<?= basename($pagina_actual) == 'secciones.php' ? 'active' : '' ?>"><i class="bi bi-grid-3x3-gap me-2"></i>Por Sección</a>
            <a href="/SICA/reportes/consolidado.php" class="<?= basename($pagina_actual) == 'consolidado.php' ? 'active' : '' ?>"><i class="bi bi-bar-chart-fill me-2"></i>Consolidado</a>
        </div>

    <?php elseif ($usuario_rol === 'docente'): ?>
        <div class="menu-label">Principal</div>
        <a href="/SICA/dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>

        <div class="menu-label">Operaciones</div>
        <a href="/SICA/incidencias/registrar.php"><i class="bi bi-plus-circle-fill"></i> Registrar Incidencia</a>
        <a href="/SICA/incidencias/"><i class="bi bi-exclamation-triangle-fill"></i> Mis Incidencias</a>
        <a href="/SICA/asistencias/escanear_qr.php"><i class="bi bi-qr-code-scan"></i> Escanear QR</a>

    <?php elseif ($usuario_rol === 'auxiliar'): ?>
        <div class="menu-label">Principal</div>
        <a href="/SICA/dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>

        <div class="menu-label">Operaciones</div>
        <a href="/SICA/asistencias/escanear_qr.php"><i class="bi bi-qr-code-scan"></i> Escanear QR</a>
        <a href="/SICA/asistencias/registrar_manual.php"><i class="bi bi-pencil-fill"></i> Registro Manual</a>
        <a href="/SICA/asistencias/"><i class="bi bi-calendar-check-fill"></i> Asistencias</a>
        <a href="/SICA/incidencias/registrar.php"><i class="bi bi-plus-circle-fill"></i> Registrar Incidencia</a>

    <?php elseif ($usuario_rol === 'estudiante'): ?>
        <div class="menu-label">Mi Información</div>
        <a href="/SICA/estudiante/dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>
        <a href="/SICA/estudiante/asistencias.php"><i class="bi bi-calendar-check-fill"></i> Mis Asistencias</a>
        <a href="/SICA/estudiante/incidencias.php"><i class="bi bi-exclamation-triangle-fill"></i> Mis Incidencias</a>

    <?php elseif ($usuario_rol === 'apoderado'): ?>
        <div class="menu-label">Mis Hijos</div>
        <a href="/SICA/apoderado/dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>
        <a href="/SICA/apoderado/hijos.php"><i class="bi bi-backpack-fill"></i> Mis Hijos</a>
        <a href="/SICA/apoderado/asistencias.php"><i class="bi bi-calendar-check-fill"></i> Asistencias</a>
        <a href="/SICA/apoderado/incidencias.php"><i class="bi bi-exclamation-triangle-fill"></i> Incidencias</a>
    <?php endif; ?>

    <div class="menu-label">Cuenta</div>
    <a href="/SICA/perfil.php"><i class="bi bi-person-gear"></i> Mi Perfil</a>
    <a href="/SICA/logout.php"><i class="bi bi-box-arrow-right"></i> Cerrar Sesión</a>
</div>

<!-- Script para cambio de año lectivo -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const anioSelect = document.getElementById('anioLectivoSelect');

    if (anioSelect) {
        anioSelect.addEventListener('change', function() {
            const anioId = this.value;

            if (confirm('¿Desea cambiar el año lectivo seleccionado? Esto recargará la página.')) {
                // Enviar petición AJAX para cambiar el año
                fetch('/SICA/config/cambiar_anio.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'anio_id=' + encodeURIComponent(anioId)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Recargar la página para aplicar el cambio
                        window.location.reload();
                    } else {
                        alert('Error: ' + data.mensaje);
                        // Restaurar selección anterior
                        this.value = '<?= $anio_seleccionado ?>';
                    }
                })
                .catch(error => {
                    alert('Error al cambiar el año lectivo: ' + error);
                    // Restaurar selección anterior
                    this.value = '<?= $anio_seleccionado ?>';
                });
            } else {
                // Restaurar selección anterior si el usuario cancela
                this.value = '<?= $anio_seleccionado ?>';
            }
        });
    }
});
</script>
