<?php
require_once 'config/db.php';

echo "<pre>";
echo "=== LIMPIEZA DE PERSONAL HUÉRFANO ===\n\n";

try {
    $pdo->beginTransaction();

    // 1. Buscar docentes sin usuario
    echo "1. Buscando docentes sin usuario...\n";
    $docentes_huerfanos = query("
        SELECT d.id, d.dni, CONCAT(d.apellido_paterno, ' ', d.nombres) as nombre
        FROM docentes d
        LEFT JOIN usuarios u ON d.id_usuario = u.id
        WHERE u.id IS NULL
    ")->fetchAll();

    echo "   Encontrados: " . count($docentes_huerfanos) . " docentes huérfanos\n";

    if (!empty($docentes_huerfanos)) {
        foreach ($docentes_huerfanos as $d) {
            echo "   - Eliminando: {$d['dni']} - {$d['nombre']}\n";
            query("DELETE FROM docentes WHERE id = ?", [$d['id']]);
        }
    } else {
        echo "   ✓ No hay docentes huérfanos\n";
    }

    echo "\n";

    // 2. Buscar auxiliares sin usuario
    echo "2. Buscando auxiliares sin usuario...\n";
    $auxiliares_huerfanos = query("
        SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre
        FROM auxiliares a
        LEFT JOIN usuarios u ON a.id_usuario = u.id
        WHERE u.id IS NULL
    ")->fetchAll();

    echo "   Encontrados: " . count($auxiliares_huerfanos) . " auxiliares huérfanos\n";

    if (!empty($auxiliares_huerfanos)) {
        foreach ($auxiliares_huerfanos as $a) {
            echo "   - Eliminando: {$a['dni']} - {$a['nombre']}\n";
            query("DELETE FROM auxiliares WHERE id = ?", [$a['id']]);
        }
    } else {
        echo "   ✓ No hay auxiliares huérfanos\n";
    }

    echo "\n";

    // 3. Buscar estudiantes sin usuario
    echo "3. Buscando estudiantes sin usuario...\n";
    $estudiantes_huerfanos = query("
        SELECT e.id, e.dni, CONCAT(e.apellido_paterno, ' ', e.nombres) as nombre
        FROM estudiantes e
        LEFT JOIN usuarios u ON e.id_usuario = u.id
        WHERE u.id IS NULL
    ")->fetchAll();

    echo "   Encontrados: " . count($estudiantes_huerfanos) . " estudiantes huérfanos\n";

    if (!empty($estudiantes_huerfanos)) {
        foreach ($estudiantes_huerfanos as $e) {
            echo "   - Eliminando: {$e['dni']} - {$e['nombre']}\n";
            query("DELETE FROM estudiantes WHERE id = ?", [$e['id']]);
        }
    } else {
        echo "   ✓ No hay estudiantes huérfanos\n";
    }

    echo "\n";

    // 4. Buscar apoderados sin usuario
    echo "4. Buscando apoderados sin usuario...\n";
    $apoderados_huerfanos = query("
        SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre
        FROM apoderados a
        LEFT JOIN usuarios u ON a.id_usuario = u.id
        WHERE u.id IS NULL
    ")->fetchAll();

    echo "   Encontrados: " . count($apoderados_huerfanos) . " apoderados huérfanos\n";

    if (!empty($apoderados_huerfanos)) {
        foreach ($apoderados_huerfanos as $a) {
            echo "   - Eliminando: {$a['dni']} - {$a['nombre']}\n";
            query("DELETE FROM apoderados WHERE id = ?", [$a['id']]);
        }
    } else {
        echo "   ✓ No hay apoderados huérfanos\n";
    }

    $pdo->commit();

    echo "\n=== VERIFICACIÓN FINAL ===\n";
    echo "Docentes: " . query("SELECT COUNT(*) FROM docentes d INNER JOIN usuarios u ON d.id_usuario = u.id")->fetchColumn() . "\n";
    echo "Auxiliares: " . query("SELECT COUNT(*) FROM auxiliares a INNER JOIN usuarios u ON a.id_usuario = u.id")->fetchColumn() . "\n";
    echo "Estudiantes: " . query("SELECT COUNT(*) FROM estudiantes e INNER JOIN usuarios u ON e.id_usuario = u.id")->fetchColumn() . "\n";
    echo "Apoderados: " . query("SELECT COUNT(*) FROM apoderados a INNER JOIN usuarios u ON a.id_usuario = u.id")->fetchColumn() . "\n";

    echo "\n✓ Limpieza completada exitosamente\n";

} catch (Exception $e) {
    $pdo->rollBack();
    echo "\n✗ ERROR: " . $e->getMessage() . "\n";
}

echo "</pre>";
?>

<p><a href='diagnosticar_personal.php' class='btn btn-primary'>Verificar de nuevo</a></p>
<p><a href='config/index.php' class='btn btn-secondary'>Ir a Configuración</a></p>
