<?php
require_once 'config/db.php';
require_once 'config/functions.php';

// Si ya está autenticado, redirigir al dashboard
if (estaAutenticado()) {
    header('Location: /SICA/dashboard.php');
    exit;
}

$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = sanitizar($_POST['usuario'] ?? '');
    $password = $_POST['password'] ?? '';

    // Validaciones básicas
    if (empty($usuario)) {
        $errores[] = 'Ingrese su usuario';
    }
    if (empty($password)) {
        $errores[] = 'Ingrese su contraseña';
    }

    if (empty($errores)) {
        $sql = "SELECT id, usuario, password, rol, estado
                FROM usuarios
                WHERE usuario = :usuario
                LIMIT 1";

        $stmt = query($sql, ['usuario' => $usuario]);

        if ($stmt && $user = $stmt->fetch()) {
            // Verificar password
            if (password_verify($password, $user['password'])) {
                // Verificar estado
                if ($user['estado'] === 'inactivo') {
                    $errores[] = 'Su cuenta está inactiva. Contacte al administrador.';
                } else {
                    // Login exitoso
                    $_SESSION['usuario_id'] = $user['id'];
                    $_SESSION['usuario'] = $user['usuario'];
                    $_SESSION['usuario_rol'] = $user['rol'];

                    // Actualizar último acceso
                    query("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = :id", ['id' => $user['id']]);

                    // Redirigir según rol
                    $redirecciones = [
                        'admin' => '/SICA/dashboard.php',
                        'docente' => '/SICA/dashboard.php',
                        'auxiliar' => '/SICA/dashboard.php',
                        'estudiante' => '/SICA/estudiante/dashboard.php',
                        'apoderado' => '/SICA/apoderado/dashboard.php'
                    ];

                    header('Location: ' . ($redirecciones[$user['rol']] ?? '/SICA/dashboard.php'));
                    exit;
                }
            } else {
                // Password incorrecto
                $errores[] = 'Usuario o contraseña incorrectos';
            }
        } else {
            $errores[] = 'Usuario o contraseña incorrectos';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Iniciar Sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #1e40af;
            --secondary-color: #3b82f6;
            --accent-color: #f59e0b;
        }
        body {
            background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 50%, #60a5fa 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .login-container {
            max-width: 450px;
            width: 100%;
            padding: 20px;
        }
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        .login-header h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 5px;
            letter-spacing: 2px;
        }
        .login-header p {
            font-size: 1rem;
            opacity: 0.9;
            margin: 0;
        }
        .login-body {
            padding: 40px 30px;
        }
        .form-control, .form-select {
            border-radius: 12px;
            padding: 14px 18px;
            border: 2px solid #e5e7eb;
            font-size: 1rem;
            transition: all 0.3s;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
        }
        .btn-login {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 12px;
            padding: 14px;
            font-size: 1.1rem;
            font-weight: 600;
            width: 100%;
            color: white;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(30, 64, 175, 0.3);
            color: white;
        }
        .input-group-text {
            background: transparent;
            border: 2px solid #e5e7eb;
            border-right: none;
            border-radius: 12px 0 0 12px;
        }
        .input-group .form-control {
            border-left: none;
            border-radius: 0 12px 12px 0;
        }
        .input-group .form-control:focus {
            border-left: none;
        }
        .alert {
            border-radius: 12px;
            border: none;
        }
        .logo-icon {
            font-size: 4rem;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="logo-icon">
                    <i class="bi bi-mortarboard-fill"></i>
                </div>
                <h1>SICA</h1>
                <p>Sistema Integrado de Convivencia y Asistencia</p>
            </div>
            <div class="login-body">
                <?php if (!empty($errores)): ?>
                    <div class="alert alert-danger mb-4">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                        <?php foreach ($errores as $error): ?>
                            <?= $error ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="mb-4">
                        <label class="form-label fw-semibold">Usuario</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                            <input type="text" class="form-control" name="usuario" placeholder="Ingrese su usuario" required autofocus value="<?= sanitizar($_POST['usuario'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label fw-semibold">Contraseña</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                            <input type="password" class="form-control" name="password" placeholder="Ingrese su contraseña" required>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="bi bi-box-arrow-in-right me-2"></i>Iniciar Sesión
                    </button>
                </form>

                <div class="text-center mt-4 text-muted">
                    <small>
                        <i class="bi bi-shield-lock-fill me-1"></i>
                        Acceso restringido a usuarios autorizados
                    </small>
                </div>
            </div>
        </div>

        <div class="text-center mt-4 text-white">
            <small>&copy; 2025 SICA - Todos los derechos reservados</small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
