<?php
require_once '../config/db.php';

echo "<pre>";
echo "=== DIAGNÓSTICO DE ÁREAS ACADÉMICAS Y PROGRAMACIONES ===\n\n";

// 1. Ver programas existentes
echo "1. PROGRAMACIONES:\n";
echo str_repeat("-", 50) . "\n";

$programaciones = query("
    SELECT p.id, p.id_anio_lectivo, an.anio,
           s.id_nivel, n.nombre as nivel_nombre,
           g.grado, s.seccion
    FROM programaciones p
    INNER JOIN secciones s ON s.id = p.id_seccion
    INNER JOIN grados g ON g.id = s.id_grado
    INNER JOIN niveles n ON n.id = s.id_nivel
    INNER JOIN anios_lectivos an ON an.id = p.id_anio_lectivo
    LIMIT 5
")->fetchAll();

foreach ($programaciones as $prog) {
    echo sprintf("  Programación ID: %d | Año: %s | Nivel: %s (ID: %d) | %s° %s\n",
        $prog['id'], $prog['anio'], $prog['nivel_nombre'], $prog['id_nivel'], $prog['grado'], $prog['seccion']);
}

echo "\n";

// 2. Ver áreas por nivel
echo "2. ÁREAS ACADÉMICAS POR NIVEL Y AÑO LECTIVO:\n";
echo str_repeat("-", 50) . "\n";

$niveles = query("SELECT id, nombre FROM niveles WHERE estado = 'activo'")->fetchAll();
$anios = query("SELECT id, anio FROM anios_lectivos WHERE estado = 'activo'")->fetchAll();

foreach ($anios as $anio) {
    echo "\n--- Año Lectivo: {$anio['anio']} (ID: {$anio['id']}) ---\n";

    foreach ($niveles as $nivel) {
        $areas = query("
            SELECT aa.id, aa.area
            FROM areas_academicas aa
            WHERE aa.id_nivel = ?
            AND aa.id_anio_lectivo = ?
            AND aa.estado = 'activo'
            ORDER BY aa.area
        ", [$nivel['id'], $anio['id']])->fetchAll();

        echo sprintf("  %s: %d área(s)\n", $nivel['nombre'], count($areas));

        foreach ($areas as $area) {
            echo sprintf("    - ID: %d | %s\n", $area['id'], $area['area']);
        }
    }
}

echo "\n";

// 3. Prueba de filtrado (simular lo que hace el AJAX)
if (!empty($programaciones)) {
    echo "3. PRUEBA DE FILTRADO (AJAX):\n";
    echo str_repeat("-", 50) . "\n";

    $prog_test = $programaciones[0];
    $id_programacion = $prog_test['id'];
    $id_nivel = $prog_test['id_nivel'];
    $id_anio_lectivo = $prog_test['id_anio_lectivo'];

    echo sprintf("Programación de prueba: ID %d\n", $id_programacion);
    echo sprintf("  - Nivel: %s (ID: %d)\n", $prog_test['nivel_nombre'], $id_nivel);
    echo sprintf("  - Año Lectivo ID: %d\n\n", $id_anio_lectivo);

    // Simular consulta del AJAX
    $sql = "
        SELECT aa.id, aa.area, aa.id_nivel, n.nombre as nivel_nombre
        FROM areas_academicas aa
        INNER JOIN niveles n ON n.id = aa.id_nivel
        WHERE aa.id_nivel = ?
        AND aa.id_anio_lectivo = ?
        AND aa.estado = 'activo'
    ";

    // Excluir áreas ya asignadas a esta programación
    $sql .= " AND aa.id NOT IN (
        SELECT id_area_academica
        FROM programaciones_docentes_areas
        WHERE id_programacion = ?
        AND estado = 'activo'
    )";

    $sql .= " ORDER BY aa.area";

    $areas_filtradas = query($sql, [$id_nivel, $id_anio_lectivo, $id_programacion])->fetchAll();

    echo sprintf("Áreas encontradas: %d\n", count($areas_filtradas));
    foreach ($areas_filtradas as $area) {
        echo sprintf("  - ID: %d | %s | %s\n", $area['id'], $area['area'], $area['nivel_nombre']);
    }
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";
echo "</pre>";

echo "<hr>";
echo "<p><a href='index.php' class='btn btn-primary'>Ir a Programaciones</a></p>";
?>
