<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirAutenticacion();

$id = $_GET['id'] ?? 0;

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener programación con información completa
$stmt = $pdo->prepare("
    SELECT
        p.id,
        p.id_seccion,
        p.id_anio_lectivo,
        p.id_tutor,
        p.id_auxiliar,
        p.capacidad,
        p.estado,
        p.observaciones,
        t.nombre as turno,
        t.abreviatura as turno_abrev,
        t.hora_ingreso,
        t.hora_salida,
        s.id_nivel,
        n.nombre AS nivel_nombre,
        s.grado,
        s.seccion,
        a.anio,
        CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ', ', d.nombres) AS tutor_nombre,
        COUNT(DISTINCT pe.id_estudiante) AS total_estudiantes,
        COUNT(DISTINCT pda.id) AS total_areas
    FROM programaciones p
    INNER JOIN secciones s ON s.id = p.id_seccion
    INNER JOIN turnos t ON t.id = p.id_turno
    INNER JOIN niveles n ON n.id = s.id_nivel
    INNER JOIN anios_lectivos a ON a.id = p.id_anio_lectivo
    LEFT JOIN docentes d ON d.id = p.id_tutor
    LEFT JOIN programaciones_estudiantes pe ON pe.id_programacion = p.id AND pe.estado = 'activo'
    LEFT JOIN programaciones_docentes_areas pda ON pda.id_programacion = p.id AND pda.estado = 'activo'
    WHERE p.id = ?
    GROUP BY p.id
");
$stmt->execute([$id]);
$programacion = $stmt->fetch();

if (!$programacion) {
    header('Location: index.php');
    exit;
}

$errores = [];
$exito = false;

// Verificar si tiene asistencias registradas
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM asistencias asi
    INNER JOIN programaciones_estudiantes pe ON pe.id_estudiante = asi.id_estudiante
    WHERE pe.id_programacion = ? AND pe.estado = 'activo'
");
$stmt->execute([$id]);
$total_asistencias = $stmt->fetch()['total'];

// Verificar si tiene incidencias registradas
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM incidencias inc
    INNER JOIN programaciones_estudiantes pe ON pe.id_estudiante = inc.id_estudiante
    WHERE pe.id_programacion = ? AND pe.estado = 'activo'
");
$stmt->execute([$id]);
$total_incidencias = $stmt->fetch()['total'];

// Procesar eliminación
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    try {
        $pdo->beginTransaction();

        if ($accion === 'eliminar') {
            // Eliminar completamente
            // Debido a CASCADE DELETE, se eliminarán automáticamente:
            // - programaciones_estudiantes
            // - programaciones_docentes_areas

            $stmt = $pdo->prepare("DELETE FROM programaciones WHERE id = ?");
            $stmt->execute([$id]);

            $pdo->commit();
            $exito = 'eliminado';

        } elseif ($accion === 'inactivar') {
            // Cambiar a inactivo
            $stmt = $pdo->prepare("
                UPDATE programaciones
                SET estado = 'inactivo', updated_at = NOW()
                WHERE id = ?
            ");
            $stmt->execute([$id]);

            $pdo->commit();
            $exito = 'inactivado';
        }

        header("Location: index.php?exito=$exito");
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        $errores[] = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Eliminar Programación - SICA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-1">
                            <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Programaciones</a></li>
                            <li class="breadcrumb-item"><a href="ver.php?id=<?= $id ?>" class="text-decoration-none">Ver</a></li>
                            <li class="breadcrumb-item active">Eliminar</li>
                        </ol>
                    </nav>
                    <h3 class="mb-0">Eliminar Programación</h3>
                </div>
            </div>
            <a href="ver.php?id=<?= $id ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver
            </a>
        </div>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Error:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach ($errores as $error): ?>
                        <li><?= htmlspecialchars($error) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Información de la Programación -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <h5 class="mb-3">
                    <?= htmlspecialchars($programacion['nivel_nombre']) ?> -
                    <?= htmlspecialchars($programacion['grado']) ?>°
                    <strong><?= htmlspecialchars($programacion['seccion']) ?></strong>
                </h5>
                <div class="row">
                    <div class="col-md-3">
                        <strong>Año Lectivo:</strong><br>
                        <?= htmlspecialchars($programacion['anio']) ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Turno:</strong><br>
                        <?= ucfirst($programacion['turno']) ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Estudiantes:</strong><br>
                        <?= $programacion['total_estudiantes'] ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Áreas:</strong><br>
                        <?= $programacion['total_areas'] ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alertas de seguridad -->
        <?php if ($total_asistencias > 0 || $total_incidencias > 0): ?>
            <div class="alert alert-danger border-0 shadow-sm">
                <h5><i class="bi bi-exclamation-triangle-fill me-2"></i>Advertencia de Seguridad</h5>
                <p class="mb-2">Esta programación tiene registros asociados:</p>
                <ul class="mb-0">
                    <?php if ($total_asistencias > 0): ?>
                        <li><strong><?= $total_asistencias ?></strong> asistencias registradas</li>
                    <?php endif; ?>
                    <?php if ($total_incidencias > 0): ?>
                        <li><strong><?= $total_incidencias ?></strong> incidencias registradas</li>
                    <?php endif; ?>
                </ul>
                <hr>
                <p class="mb-0">
                    <strong>Recomendación:</strong> Solo cambia el estado a <strong>Inactivo</strong> para mantener el historial.
                    Si eliminas la programación, se perderán los vínculos con estos registros.
                </p>
            </div>
        <?php else: ?>
            <div class="alert alert-warning border-0 shadow-sm">
                <h5><i class="bi bi-info-circle me-2"></i>Información</h5>
                <p class="mb-0">
                    Esta programación no tiene asistencias ni incidencias registradas.
                    Puedes eliminarla completamente sin afectar otros datos.
                </p>
            </div>
        <?php endif; ?>

        <!-- Opciones de Eliminación -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h5 class="mb-4">¿Qué deseas hacer con esta programación?</h5>

                <form method="POST">
                    <div class="row g-3">
                        <!-- Opción 1: Cambiar a Inactivo -->
                        <div class="col-md-6">
                            <div class="card border-warning h-100">
                                <div class="card-body text-center">
                                    <div class="mb-3">
                                        <i class="bi bi-pause-circle text-warning" style="font-size: 3rem;"></i>
                                    </div>
                                    <h6 class="card-title">Cambiar a Inactivo</h6>
                                    <p class="card-text small text-muted">
                                        La programación ya no estará disponible para nuevas asignaciones,
                                        pero se mantendrán todos los datos históricos (estudiantes, áreas, asistencias, incidencias).
                                    </p>
                                    <button type="submit" name="accion" value="inactivar" class="btn btn-warning w-100">
                                        <i class="bi bi-pause me-2"></i>Cambiar a Inactivo
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Opción 2: Eliminar -->
                        <div class="col-md-6">
                            <div class="card border-danger h-100">
                                <div class="card-body text-center">
                                    <div class="mb-3">
                                        <i class="bi bi-trash text-danger" style="font-size: 3rem;"></i>
                                    </div>
                                    <h6 class="card-title">Eliminar Completamente</h6>
                                    <p class="card-text small text-muted">
                                        <?php if ($total_asistencias > 0 || $total_incidencias > 0): ?>
                                            <strong class="text-danger">Se eliminarán todos los vínculos</strong> con estudiantes,
                                            áreas y se perderá la relación con asistencias e incidencias.
                                            Esta acción no se puede deshacer.
                                        <?php else: ?>
                                            Se eliminará la programación y todos sus datos asociados.
                                            Esta acción no se puede deshacer.
                                        <?php endif; ?>
                                    </p>
                                    <button type="submit" name="accion" value="eliminar"
                                            class="btn btn-danger w-100"
                                            onclick="return confirm('¿Estás SEGURO de que quieres eliminar esta programación? Esta acción NO se puede deshacer.')">
                                        <i class="bi bi-trash me-2"></i>Eliminar Completamente
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Botón Cancelar -->
        <div class="text-center mt-4">
            <a href="ver.php?id=<?= $id ?>" class="btn btn-outline-secondary btn-lg">
                <i class="bi bi-x-circle me-2"></i>Cancelar
            </a>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
