<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirAutenticacion();

$anio_seleccionado = getAnioLectivoSeleccionado();
$info_anio = getInfoAnioLectivoSeleccionado();

// Filtros
$filtro_nivel = $_GET['filtro_nivel'] ?? '';
$filtro_grado = $_GET['filtro_grado'] ?? '';
$filtro_turno = $_GET['filtro_turno'] ?? '';
$filtro_busqueda = $_GET['filtro_busqueda'] ?? '';

// Obtener niveles para filtros
$niveles = query("SELECT id, nombre FROM niveles WHERE estado = 'activo' ORDER BY nombre")->fetchAll();

// Obtener grados disponibles
$grados = [];
if ($filtro_nivel) {
    $stmt = $pdo->prepare("
        SELECT DISTINCT g.grado
        FROM grados g
        WHERE g.id_nivel = ? AND g.estado = 'activo'
        ORDER BY g.grado
    ");
    $stmt->execute([$filtro_nivel]);
    $grados = $stmt->fetchAll(PDO::FETCH_COLUMN);
}

// Construir query para programaciones
$sql = "
    SELECT
        p.id,
        p.id_seccion,
        p.id_anio_lectivo,
        p.id_tutor,
        p.id_auxiliar,
        t.nombre as turno,
        t.abreviatura as turno_abrev,
        t.hora_ingreso,
        t.hora_salida,
        t.tolerancia_minutos,
        p.capacidad,
        p.estado,
        s.id_nivel,
        n.nombre AS nivel_nombre,
        s.grado,
        s.seccion,
        a.anio,
        CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ', ', d.nombres) AS tutor_nombre,
        CONCAT(aux.apellido_paterno, ' ', aux.apellido_materno, ', ', aux.nombres) AS auxiliar_nombre,
        COUNT(DISTINCT pe.id_estudiante) AS total_estudiantes,
        COUNT(DISTINCT pda.id) AS total_areas
    FROM programaciones p
    INNER JOIN secciones s ON s.id = p.id_seccion
    INNER JOIN turnos t ON t.id = p.id_turno
    INNER JOIN niveles n ON n.id = s.id_nivel
    INNER JOIN anios_lectivos a ON a.id = p.id_anio_lectivo
    LEFT JOIN docentes d ON d.id = p.id_tutor
    LEFT JOIN auxiliares aux ON aux.id = p.id_auxiliar
    LEFT JOIN programaciones_estudiantes pe ON pe.id_programacion = p.id AND pe.estado = 'activo'
    LEFT JOIN programaciones_docentes_areas pda ON pda.id_programacion = p.id AND pda.estado = 'activo'
    WHERE p.id_anio_lectivo = :anio_lectivo
";

$params = ['anio_lectivo' => $anio_seleccionado];

if ($filtro_nivel) {
    $sql .= " AND s.id_nivel = :filtro_nivel";
    $params['filtro_nivel'] = $filtro_nivel;
}

if ($filtro_grado) {
    $sql .= " AND s.grado = :filtro_grado";
    $params['filtro_grado'] = $filtro_grado;
}

if ($filtro_turno) {
    $sql .= " AND p.id_turno = :filtro_turno";
    $params['filtro_turno'] = $filtro_turno;
}

if ($filtro_busqueda) {
    $sql .= " AND (
        CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ' ', d.nombres) LIKE :busqueda1
        OR s.seccion LIKE :busqueda2
        OR CONCAT(s.grado, ' ', s.seccion) LIKE :busqueda3
    )";
    $busqueda_param = "%$filtro_busqueda%";
    $params['busqueda1'] = $busqueda_param;
    $params['busqueda2'] = $busqueda_param;
    $params['busqueda3'] = $busqueda_param;
}

$sql .= " GROUP BY p.id ORDER BY n.nombre, s.grado, s.seccion";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$programaciones = $stmt->fetchAll();

// Contar totales
$total_programaciones = count($programaciones);
$total_activas = 0;
foreach ($programaciones as $prog) {
    if ($prog['estado'] == 'activo') $total_activas++;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Programaciones - SICA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <h3 class="mb-1">Programaciones Académicas</h3>
                    <p class="text-muted mb-0">Gestión de secciones por año lectivo</p>
                </div>
            </div>
            <a href="crear.php" class="btn btn-primary">
                <i class="bi bi-plus-circle me-2"></i>Nueva Programación
            </a>
        </div>

        <!-- Estadísticas rápidas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-0 shadow-sm stats-card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Total Programaciones</h6>
                                <h3 class="mb-0"><?= $total_programaciones ?></h3>
                            </div>
                            <div class="icon-box bg-primary bg-opacity-10 text-primary">
                                <i class="bi bi-calendar-week fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm stats-card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Activas</h6>
                                <h3 class="mb-0"><?= $total_activas ?></h3>
                            </div>
                            <div class="icon-box bg-success bg-opacity-10 text-success">
                                <i class="bi bi-check-circle fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm stats-card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Año Lectivo</h6>
                                <h5 class="mb-0"><?= htmlspecialchars($info_anio['anio']) ?></h5>
                            </div>
                            <div class="icon-box bg-info bg-opacity-10 text-info">
                                <i class="bi bi-calendar-range fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if (isset($_GET['exito'])): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle me-2"></i>
                <?php if ($_GET['exito'] == 'eliminado'): ?>
                    Programación eliminada correctamente.
                <?php elseif ($_GET['exito'] == 'inactivado'): ?>
                    Programación cambiada a inactivo correctamente.
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <!-- Filtros -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Nivel</label>
                        <select name="filtro_nivel" class="form-select" onchange="this.form.submit(); actualizarGrados(this.value);">
                            <option value="">Todos los niveles</option>
                            <?php foreach ($niveles as $nivel): ?>
                                <option value="<?= $nivel['id'] ?>" <?= $filtro_nivel == $nivel['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($nivel['nombre']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label fw-semibold">Grado</label>
                        <select name="filtro_grado" class="form-select" onchange="this.form.submit();">
                            <option value="">Todos</option>
                            <?php foreach ($grados as $grado): ?>
                                <option value="<?= htmlspecialchars($grado) ?>" <?= $filtro_grado == $grado ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($grado) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label fw-semibold">Turno</label>
                        <select name="filtro_turno" class="form-select" onchange="this.form.submit();">
                            <option value="">Todos</option>
                            <option value="mañana" <?= $filtro_turno == 'mañana' ? 'selected' : '' ?>>Mañana</option>
                            <option value="tarde" <?= $filtro_turno == 'tarde' ? 'selected' : '' ?>>Tarde</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Buscar</label>
                        <input type="text" name="filtro_busqueda" class="form-control"
                               placeholder="Tutor, sección..."
                               value="<?= htmlspecialchars($filtro_busqueda) ?>">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-funnel me-1"></i>Filtrar
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Lista de Cards -->
        <?php if (empty($programaciones)): ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox fs-1 text-muted"></i>
                <p class="text-muted mt-3">
                    <?= empty($filtro_nivel) && empty($filtro_grado) && empty($filtro_turno)
                        ? 'No hay programaciones registradas. <a href="crear.php">Crear la primera</a>.'
                        : 'No se encontraron programaciones con los filtros seleccionados.' ?>
                </p>
            </div>
        <?php else: ?>
            <div class="row">
                <?php foreach ($programaciones as $prog): ?>
                    <?php
                    $porcentaje_estudiantes = $prog['capacidad'] > 0
                        ? round(($prog['total_estudiantes'] / $prog['capacidad']) * 100)
                        : 0;

                    $color_turno = (strtolower($prog['turno']) == 'mañana' || strtolower($prog['turno']) == 'mañana') ? '#f59b23' : '#3b82f6';
                    $estado_badge = $prog['estado'] == 'activo'
                        ? 'bg-success'
                        : ($prog['estado'] == 'finalizado' ? 'bg-secondary' : 'bg-danger');
                    ?>
                    <div class="col-xl-4 col-lg-6 mb-4">
                        <div class="card border-0 shadow-sm h-100 programacion-card">
                            <div class="card-header bg-white border-bottom py-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1">
                                            <span class="badge bg-light text-dark border">Nivel: <?= htmlspecialchars($prog['nivel_nombre']) ?></span>
                                        </h6>
                                        <h5 class="mb-0">
                                            <?= htmlspecialchars($prog['grado']) ?>°
                                            <strong><?= htmlspecialchars($prog['seccion']) ?></strong>
                                        </h5>
                                    </div>
                                    <span class="badge <?= $estado_badge ?>">
                                        <?= ucfirst(htmlspecialchars($prog['estado'])) ?>
                                    </span>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <span class="badge" style="background-color: <?= $color_turno ?>; color: white;">
                                        <i class="bi bi-sunrise me-1"></i><?= ucfirst($prog['turno']) ?>
                                    </span>
                                    <small class="text-muted ms-2">
                                        <i class="bi bi-clock me-1"></i>
                                        <?= date('H:i', strtotime($prog['hora_ingreso'] ?? '00:00')) ?>
                                        -
                                        <?= date('H:i', strtotime($prog['hora_salida'] ?? '00:00')) ?>
                                    </small>
                                </div>

                                <div class="info-item mb-2">
                                    <i class="bi bi-person-workspace text-primary"></i>
                                    <strong>Tutor:</strong>
                                    <?= $prog['tutor_nombre']
                                        ? htmlspecialchars($prog['tutor_nombre'])
                                        : '<span class="text-muted">Sin asignar</span>' ?>
                                </div>

                                <div class="info-item mb-2">
                                    <i class="bi bi-clipboard-data text-info"></i>
                                    <strong>Auxiliar:</strong>
                                    <?= $prog['auxiliar_nombre']
                                        ? htmlspecialchars($prog['auxiliar_nombre'])
                                        : '<span class="text-muted">Sin asignar</span>' ?>
                                </div>

                                <div class="info-item mb-3">
                                    <i class="bi bi-book text-warning"></i>
                                    <strong>Áreas:</strong>
                                    <span class="badge bg-warning text-dark">
                                        <?= $prog['total_areas'] ?> asignadas
                                    </span>
                                </div>

                                <div class="border-top pt-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="text-muted">
                                            <i class="bi bi-people me-1"></i>Estudiantes
                                        </span>
                                        <strong><?= $prog['total_estudiantes'] ?> / <?= $prog['capacidad'] ?></strong>
                                    </div>
                                    <div class="progress" style="height: 8px;">
                                        <?php if ($porcentaje_estudiantes > 100): ?>
                                            <div class="progress-bar bg-danger" style="width: 100%"></div>
                                        <?php elseif ($porcentaje_estudiantes >= 90): ?>
                                            <div class="progress-bar bg-warning" style="width: <?= $porcentaje_estudiantes ?>%"></div>
                                        <?php else: ?>
                                            <div class="progress-bar bg-success" style="width: <?= $porcentaje_estudiantes ?>%"></div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($porcentaje_estudiantes >= 90): ?>
                                        <small class="text-danger">
                                            <i class="bi bi-exclamation-triangle me-1"></i>
                                            Capacidad casi llena
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-footer bg-white border-top py-3">
                                <div class="btn-group w-100" role="group">
                                    <a href="ver.php?id=<?= $prog['id'] ?>" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-eye me-1"></i>Ver
                                    </a>
                                    <a href="editar.php?id=<?= $prog['id'] ?>" class="btn btn-outline-secondary btn-sm">
                                        <i class="bi bi-pencil me-1"></i>Editar
                                    </a>
                                    <button class="btn btn-outline-success btn-sm" onclick="asignarEstudiantes(<?= $prog['id'] ?>)">
                                        <i class="bi bi-person-plus me-1"></i>Estudiantes
                                    </button>
                                    <a href="eliminar.php?id=<?= $prog['id'] ?>" class="btn btn-outline-danger btn-sm"
                                       onclick="return confirm('¿Estás seguro de que deseas eliminar esta programación?')">
                                        <i class="bi bi-trash me-1"></i>Eliminar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>

    <script>
    function actualizarGrados(idNivel) {
        const form = document.querySelector('form');
        const inputGrado = form.querySelector('[name="filtro_grado"]');
        inputGrado.value = '';
        form.submit();
    }

    function asignarEstudiantes(idProgramacion) {
        window.location.href = `asignar_estudiantes.php?id=${idProgramacion}`;
    }

    // Actualizar estadísticas con AJAX cada 30 segundos
    setInterval(() => {
        // Opcional: refrescar estadísticas de cada card
    }, 30000);
    </script>
</body>
</html>
