<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirAutenticacion();
requerirRol(['admin', 'auxiliar']);

$anio_lectivo_id = getAnioLectivoSeleccionado();
$anio_lectivo_nombre = $_SESSION['anio_lectivo_nombre'] ?? '';

$page_title = "Reportes de Asistencia por Sección - SICA";

// Obtener niveles para el filtro
$niveles = query("SELECT id, nombre FROM niveles WHERE estado = 'activo' ORDER BY nombre")->fetchAll();

// Obtener turnos para el filtro
$turnos = query("SELECT id, nombre, abreviatura FROM turnos WHERE estado = 'activo' ORDER BY id")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.2" rel="stylesheet">
    <style>
        /* Contenedor oculto para impresión */
        #printVersion {
            display: none;
        }

        @media print {
            /* Ocultar TODO excepto printVersion */
            body > *:not(#printVersion) {
                display: none !important;
            }

            /* Reset completo */
            html, body {
                margin: 0 !important;
                padding: 0 !important;
                width: 100% !important;
                height: auto !important;
                overflow: visible !important;
                background: white !important;
            }

            /* Mostrar solo printVersion */
            #printVersion {
                display: block !important;
                position: absolute !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                background: white !important;
                padding: 0 !important;
                margin: 0 !important;
                z-index: 999999 !important;
            }

            /* Encabezado estilo reporte individual */
            .reporte-header {
                border-bottom: 2px solid #1e3a8a !important;
                padding-bottom: 8px !important;
                margin-bottom: 10px !important;
                text-align: center !important;
            }
            .reporte-titulo {
                color: #1e3a8a !important;
                font-size: 10pt !important;
                font-weight: bold !important;
                margin: 0 !important;
                text-transform: uppercase;
            }
            .reporte-subtitulo {
                color: #64748b !important;
                font-size: 9pt !important;
                margin: 2px 0 0 0 !important;
                font-weight: 600 !important;
            }
            .reporte-info {
                background: #f8fafc !important;
                padding: 4px 8px !important;
                border-radius: 4px !important;
                margin-bottom: 10px !important;
                font-size: 8pt !important;
            }

            /* Tabla de grilla mensual */
            .reporte-grilla {
                width: 100% !important;
                border-collapse: collapse !important;
                margin-top: 10px !important;
                font-size: 8pt !important;
                page-break-inside: avoid;
                table-layout: fixed !important;
            }
            .reporte-grilla th {
                background: #1e3a8a !important;
                color: white !important;
                padding: 6px 2px !important;
                text-align: center !important;
                font-weight: bold !important;
                border: 1px solid #1e3a8a !important;
                font-size: 7pt !important;
                height: auto !important;
                vertical-align: middle !important;
                width: 3.5% !important;
            }
            .reporte-grilla td {
                padding: 3px 2px !important;
                border: 1px solid #e2e8f0 !important;
                font-size: 8pt !important;
            }
            .reporte-grilla tr:nth-child(even) {
                background: #f8fafc !important;
            }
            .reporte-grilla .celda-nro {
                text-align: center !important;
                font-weight: bold !important;
                font-size: 7pt !important;
                width: 3% !important;
            }
            .reporte-grilla .celda-nombre {
                text-align: left !important;
                font-weight: 500 !important;
                white-space: nowrap !important;
                width: 22% !important;
                overflow: hidden !important;
                text-overflow: ellipsis !important;
                font-size: 7pt !important;
            }
            .reporte-grilla .celda-dni {
                text-align: center !important;
                font-size: 7pt !important;
                color: #64748b !important;
                width: 10% !important;
            }
            .reporte-grilla .celda-fecha {
                text-align: center !important;
                font-weight: bold !important;
                font-size: 7pt !important;
            }
            .reporte-grilla .celda-asistencia {
                text-align: center !important;
                font-weight: bold !important;
                font-size: 7pt !important;
            }

            /* Códigos de asistencia */
            .codigo-A { color: #166534; background: #dcfce7; }
            .codigo-T { color: #92400e; background: #fef3c7; }
            .codigo-TJ { color: #1e40af; background: #dbeafe; }
            .codigo-FJ { color: #6b21a8; background: #e9d5ff; }
            .codigo-FI { color: #991b1b; background: #fee2e2; }
            .codigo-vacio { color: #9ca3af; background: #f3f4f6; }

            /* Resumen */
            .reporte-resumen {
                background: #f8fafc !important;
                color: #1e3a8a !important;
                padding: 4px 6px !important;
                margin-top: 8px !important;
                border: 1px solid #e2e8f0 !important;
                border-radius: 3px !important;
                font-size: 6pt !important;
            }
            .reporte-resumen p {
                margin: 1px 0 !important;
                line-height: 1.2 !important;
            }

            /* Forzar impresión de fondo */
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }

            /* Asegurar que el contenido sea visible */
            @page {
                size: A4 landscape;
                margin: 5mm;
            }

            /* Evitar saltos de página */
            * {
                page-break-inside: avoid !important;
            }

            #printVersion, .reporte-header, .reporte-grilla, .reporte-resumen {
                page-break-inside: avoid !important;
                page-break-after: avoid !important;
                page-break-before: avoid !important;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4 no-print">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-1">Reportes por Sección</h3>
                <p class="text-muted mb-0">Genera reportes de asistencia por sección/programación</p>
            </div>
        </div>
        <div class="d-flex gap-2">
            <button class="btn btn-outline-danger" onclick="exportarPDF()">
                <i class="bi bi-file-earmark-pdf me-1"></i> PDF Mensual
            </button>
            <button class="btn btn-outline-primary" onclick="window.print()">
                <i class="bi bi-printer me-1"></i> Imprimir
            </button>
            <a href="/SICA/dashboard.php" class="btn btn-outline-secondary">
                <i class="bi bi-house me-1"></i> Volver
            </a>
        </div>
    </div>

    <!-- Card de filtros -->
    <div class="card mb-4 no-print">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-funnel me-2"></i>Seleccionar Sección</h5>
        </div>
        <div class="card-body">
            <form id="formFiltros" onsubmit="return false;">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Nivel</label>
                        <select class="form-select" id="filtroNivel" onchange="cargarGrados()">
                            <option value="">Todos los niveles</option>
                            <?php foreach ($niveles as $nivel): ?>
                                <option value="<?= $nivel['id'] ?>"><?= htmlspecialchars($nivel['nombre']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Turno</label>
                        <select class="form-select" id="filtroTurno" onchange="cargarSecciones()">
                            <option value="">Todos los turnos</option>
                            <?php foreach ($turnos as $turno): ?>
                                <option value="<?= $turno['id'] ?>"><?= htmlspecialchars($turno['nombre']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Sección</label>
                        <select class="form-select" id="filtroSeccion" onchange="cargarEstudiantes()">
                            <option value="">Seleccione nivel y turno primero</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label fw-bold">Acción</label>
                        <button class="btn btn-success w-100" onclick="generarReporte()" id="btnGenerar" disabled>
                            <i class="bi bi-file-earmark-text me-1"></i>Generar
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Resumen de la sección seleccionada -->
    <div id="resumenSeccion" style="display: none;">
        <div class="card mb-4" style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%); border: none;">
            <div class="card-body text-white">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <h4 class="mb-1" id="seccionTitulo">-</h4>
                        <p class="mb-1">
                            <i class="bi bi-people-fill me-2"></i>
                            <strong>Total estudiantes:</strong> <span id="seccionTotal">-</span>
                            <span class="mx-3">|</span>
                            <i class="bi bi-person-check me-2"></i>
                            <strong>Presentes hoy:</strong> <span id="seccionPresentesHoy">-</span>
                        </p>
                        <p class="mb-0">
                            <i class="bi bi-person-workspace me-2"></i>
                            <strong>Tutor:</strong> <span id="seccionTutor">-</span>
                            <span class="mx-3">|</span>
                            <i class="bi bi-clipboard-data me-2"></i>
                            <strong>Auxiliar:</strong> <span id="seccionAuxiliar">-</span>
                        </p>
                    </div>
                    <div class="col-md-4 text-end">
                        <div class="progress-circle">
                            <svg>
                                <circle cx="60" cy="60" r="54" stroke="#ffffff40" stroke-width="8" fill="none"/>
                                <circle id="circleProgresoSeccion" cx="60" cy="60" r="54" stroke="#10b981" stroke-width="8" fill="none"
                                    stroke-dasharray="339.292" stroke-dashoffset="0" stroke-linecap="round"/>
                            </svg>
                            <div class="percentage text-white">
                                <span id="porcentajeAsistenciaSeccion">0</span>%
                            </div>
                        </div>
                        <p class="mt-2 mb-0 text-white small">Asistencia Hoy</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Estadísticas de la sección -->
    <div id="estadisticasSeccion" style="display: none;">
        <div class="row mb-4">
            <div class="col-md-3 mb-3">
                <div class="card border-success">
                    <div class="card-body text-center">
                        <i class="bi bi-check-circle-fill text-success fs-1"></i>
                        <h5 class="mt-2 mb-1" id="statAsistencias">-</h5>
                        <p class="text-muted mb-0 small">Asistencias</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card border-warning">
                    <div class="card-body text-center">
                        <i class="bi bi-clock-fill text-warning fs-1"></i>
                        <h5 class="mt-2 mb-1" id="statTardanzas">-</h5>
                        <p class="text-muted mb-0 small">Tardanzas</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card border-info">
                    <div class="card-body text-center">
                        <i class="bi bi-calendar-check text-info fs-1"></i>
                        <h5 class="mt-2 mb-1" id="statFaltasJustificadas">-</h5>
                        <p class="text-muted mb-0 small">Faltas Justificadas</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card border-danger">
                    <div class="card-body text-center">
                        <i class="bi bi-calendar-x text-danger fs-1"></i>
                        <h5 class="mt-2 mb-1" id="statFaltasInjustificadas">-</h5>
                        <p class="text-muted mb-0 small">Faltas Injustificadas</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros de periodo -->
    <div id="filtrosPeriodo" class="card mb-4" style="display: none;">
        <div class="card-body">
            <div class="row g-3 align-items-end">
                <div class="col-md-3">
                    <label class="form-label fw-bold">Periodo</label>
                    <select class="form-select" id="periodoPredefinido" onchange="cambiarPeriodo()">
                        <option value="hoy">Hoy</option>
                        <option value="semana">Esta semana</option>
                        <option value="mes" selected>Este mes</option>
                        <option value="trimestre">Este trimestre</option>
                        <option value="anio">Año lectivo completo</option>
                        <option value="personalizado">Personalizado</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Fecha Inicio</label>
                    <input type="date" class="form-control" id="fechaInicio" onchange="actualizarReporte()">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Fecha Fin</label>
                    <input type="date" class="form-control" id="fechaFin" onchange="actualizarReporte()">
                </div>
                <div class="col-md-3">
                    <button class="btn btn-primary w-100" onclick="actualizarReporte()">
                        <i class="bi bi-arrow-clockwise me-1"></i> Actualizar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading -->
    <div id="loadingIndicator" class="text-center py-5" style="display: none;">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Cargando...</span>
        </div>
        <p class="mt-3 text-muted">Cargando datos de la sección...</p>
    </div>

    <!-- Tabla de estudiantes de la sección -->
    <div id="tablaContainer" style="display: none;">
        <div class="card">
            <div class="card-header bg-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="bi bi-people me-2"></i>Estudiantes de la Sección
                    </h5>
                    <span class="badge bg-secondary" id="totalRegistros">0 estudiantes</span>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>DNI</th>
                                <th>Estudiante</th>
                                <th>Asistencias</th>
                                <th>Tardanzas</th>
                                <th>F. Justificadas</th>
                                <th>F. Injustificadas</th>
                                <th>% Asistencia</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="tablaEstudiantes">
                            <tr>
                                <td colspan="8" class="text-center text-muted">
                                    No hay estudiantes en esta sección
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Instrucciones -->
    <div id="instruccionesContainer" class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-grid-3x3-gap text-primary" style="font-size: 4rem;"></i>
            <h4 class="mt-3">Reportes por Sección</h4>
            <p class="text-muted mb-4">Genera reportes de asistencia para una sección específica</p>
            <div class="row text-start">
                <div class="col-md-4 mb-3">
                    <div class="card h-100 border-primary">
                        <div class="card-body">
                            <h6 class="card-title text-primary">
                                <i class="bi bi-1-circle-fill me-2"></i>Paso 1
                            </h6>
                            <p class="card-text small">Selecciona el nivel educativo (Inicial, Primaria o Secundaria).</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="card h-100 border-primary">
                        <div class="card-body">
                            <h6 class="card-title text-primary">
                                <i class="bi bi-2-circle-fill me-2"></i>Paso 2
                            </h6>
                            <p class="card-text small">Selecciona el turno (Mañana o Tarde) y luego la sección específica.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="card h-100 border-primary">
                        <div class="card-body">
                            <h6 class="card-title text-primary">
                                <i class="bi bi-3-circle-fill me-2"></i>Paso 3
                            </h6>
                            <p class="card-text small">Haz clic en "Generar" para ver el reporte con todos los estudiantes y sus estadísticas.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>

    <!-- Versión de Impresión/PDF (oculta en pantalla) -->
    <div id="printVersion" class="print-only">
        <!-- El contenido se generará dinámicamente con JavaScript -->
    </div>

    <script>
        const ANIO_LECTIVO_ID = <?php echo $anio_lectivo_id; ?>;
        let programacionSeleccionada = null;
        let datosReporte = null;

        // Inicializar fechas
        document.addEventListener('DOMContentLoaded', function() {
            inicializarFechas();
        });

        function inicializarFechas() {
            <?php
            $anio_info = query("SELECT fecha_inicio, fecha_fin FROM anios_lectivos WHERE id = ?", [$anio_lectivo_id])->fetch();
            if ($anio_info) {
            ?>
            document.getElementById('fechaInicio').value = '<?php echo $anio_info['fecha_inicio']; ?>';
            document.getElementById('fechaFin').value = '<?php echo $anio_info['fecha_fin']; ?>';
            <?php
            }
            ?>
        }

        function cargarGrados() {
            // Cargar secciones filtradas por nivel y turno
            cargarSecciones();
        }

        function cargarSecciones() {
            const nivelId = document.getElementById('filtroNivel').value;
            const turnoId = document.getElementById('filtroTurno').value;

            if (!nivelId || !turnoId) {
                document.getElementById('filtroSeccion').innerHTML = '<option value="">Seleccione nivel y turno</option>';
                return;
            }

            // Mostrar loading
            document.getElementById('loadingIndicator').style.display = 'block';
            document.getElementById('instruccionesContainer').style.display = 'none';

            fetch(`ajax_reportes.php?accion=buscar_secciones&nivel=${nivelId}&turno=${turnoId}&anio_lectivo=${ANIO_LECTIVO_ID}`)
                .then(response => response.json())
                .then(data => {
                    if (!data.success) {
                        throw new Error(data.mensaje);
                    }

                    const select = document.getElementById('filtroSeccion');
                    select.innerHTML = '<option value="">Seleccione una sección</option>';

                    data.secciones.forEach(seccion => {
                        const option = document.createElement('option');
                        option.value = seccion.id;
                        option.textContent = `${seccion.nivel} - ${seccion.grado} "${seccion.seccion}" (${seccion.turno})`;
                        select.appendChild(option);
                    });

                    document.getElementById('btnGenerar').disabled = true;
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al cargar secciones: ' + error.message);
                })
                .finally(() => {
                    document.getElementById('loadingIndicator').style.display = 'none';
                });
        }

        function cargarEstudiantes() {
            const seccionId = document.getElementById('filtroSeccion').value;
            document.getElementById('btnGenerar').disabled = !seccionId;
        }

        function generarReporte() {
            const programacionId = document.getElementById('filtroSeccion').value;

            if (!programacionId) {
                alert('Seleccione una sección');
                return;
            }

            programacionSeleccionada = programacionId;
            actualizarReporte();
        }

        function cambiarPeriodo() {
            const periodo = document.getElementById('periodoPredefinido').value;
            const hoy = new Date();
            let fechaInicio, fechaFin;

            switch(periodo) {
                case 'hoy':
                    fechaInicio = hoy;
                    fechaFin = hoy;
                    break;
                case 'semana':
                    const diaSemana = hoy.getDay();
                    const lunes = new Date(hoy);
                    lunes.setDate(hoy.getDate() - (diaSemana === 0 ? 6 : diaSemana - 1));
                    fechaInicio = lunes;
                    fechaFin = hoy;
                    break;
                case 'mes':
                    const primerDiaMes = new Date(hoy.getFullYear(), hoy.getMonth(), 1);
                    fechaInicio = primerDiaMes;
                    fechaFin = hoy;
                    break;
                case 'trimestre':
                    const mesActual = hoy.getMonth();
                    const inicioTrimestre = new Date(hoy.getFullYear(), Math.floor(mesActual / 3) * 3, 1);
                    fechaInicio = inicioTrimestre;
                    fechaFin = hoy;
                    break;
                case 'anio':
                    inicializarFechas();
                    actualizarReporte();
                    return;
                case 'personalizado':
                    return;
            }

            document.getElementById('fechaInicio').value = formatDateForInput(fechaInicio);
            document.getElementById('fechaFin').value = formatDateForInput(fechaFin);

            actualizarReporte();
        }

        function formatDateForInput(date) {
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        function actualizarReporte() {
            const fechaInicio = document.getElementById('fechaInicio').value;
            const fechaFin = document.getElementById('fechaFin').value;

            if (!fechaInicio || !fechaFin) {
                alert('Seleccione ambas fechas');
                return;
            }

            if (!programacionSeleccionada) {
                alert('Seleccione una sección primero');
                return;
            }

            // Mostrar loading
            document.getElementById('loadingIndicator').style.display = 'block';
            document.getElementById('resumenSeccion').style.display = 'none';
            document.getElementById('estadisticasSeccion').style.display = 'none';
            document.getElementById('filtrosPeriodo').style.display = 'none';
            document.getElementById('tablaContainer').style.display = 'none';
            document.getElementById('instruccionesContainer').style.display = 'none';

            fetch(`ajax_reportes.php?accion=obtener_reporte_seccion&programacion_id=${programacionSeleccionada}&fecha_inicio=${fechaInicio}&fecha_fin=${fechaFin}`)
                .then(response => response.json())
                .then(data => {
                    if (!data.success) {
                        throw new Error(data.mensaje);
                    }
                    mostrarReporte(data.data);
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al cargar el reporte: ' + error.message);
                    document.getElementById('instruccionesContainer').style.display = 'block';
                })
                .finally(() => {
                    document.getElementById('loadingIndicator').style.display = 'none';
                });
        }

        function mostrarReporte(data) {
            datosReporte = data;

            // Mostrar secciones
            document.getElementById('resumenSeccion').style.display = 'block';
            document.getElementById('estadisticasSeccion').style.display = 'block';
            document.getElementById('filtrosPeriodo').style.display = 'block';
            document.getElementById('tablaContainer').style.display = 'block';

            // Información de la sección
            const prog = data.programacion;
            document.getElementById('seccionTitulo').textContent =
                `${prog.nivel} - ${prog.grado} "${prog.seccion}" (${prog.turno})`;

            document.getElementById('seccionTotal').textContent = data.estadisticas.total_estudiantes;
            document.getElementById('seccionPresentesHoy').textContent = data.estadisticas.presentes_hoy || 0;
            document.getElementById('seccionTutor').textContent = prog.tutor_nombre || 'No asignado';
            document.getElementById('seccionAuxiliar').textContent = prog.auxiliar_nombre || 'No asignado';

            // Círculo de progreso
            const porcentaje = data.estadisticas.porcentaje_asistencia || 0;
            document.getElementById('porcentajeAsistenciaSeccion').textContent = porcentaje;
            actualizarCirculoProgreso(porcentaje);

            // Estadísticas
            document.getElementById('statAsistencias').textContent = data.estadisticas.total_asistencias || 0;
            document.getElementById('statTardanzas').textContent = data.estadisticas.total_tardanzas || 0;
            document.getElementById('statFaltasJustificadas').textContent = data.estadisticas.total_faltas_justificadas || 0;
            document.getElementById('statFaltasInjustificadas').textContent = data.estadisticas.total_faltas_injustificadas || 0;

            // Tabla de estudiantes
            mostrarEstudiantes(data.estudiantes);
        }

        function actualizarCirculoProgreso(porcentaje) {
            const circunferencia = 339.292;
            const offset = circunferencia - (porcentaje / 100) * circunferencia;
            const circle = document.getElementById('circleProgresoSeccion');

            circle.style.strokeDashoffset = offset;

            // Color según porcentaje
            if (porcentaje >= 90) {
                circle.setAttribute('stroke', '#10b981');
            } else if (porcentaje >= 70) {
                circle.setAttribute('stroke', '#f59e0b');
            } else {
                circle.setAttribute('stroke', '#ef4444');
            }
        }

        function mostrarEstudiantes(estudiantes) {
            const tbody = document.getElementById('tablaEstudiantes');
            document.getElementById('totalRegistros').textContent = estudiantes.length + ' estudiantes';

            if (estudiantes.length === 0) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="8" class="text-center text-muted">
                            No hay estudiantes en esta sección
                        </td>
                    </tr>
                `;
                return;
            }

            tbody.innerHTML = estudiantes.map(est => {
                const porcentaje = est.porcentaje_asistencia || 0;
                const colorBarra = porcentaje >= 90 ? 'success' : (porcentaje >= 70 ? 'warning' : 'danger');

                return `
                    <tr>
                        <td><strong>${est.dni}</strong></td>
                        <td>${est.apellido_paterno} ${est.apellido_materno}, ${est.nombres}</td>
                        <td><span class="badge bg-success">${est.total_asistencias || 0}</span></td>
                        <td><span class="badge bg-warning">${est.total_tardanzas || 0}</span></td>
                        <td><span class="badge bg-info">${est.total_faltas_justificadas || 0}</span></td>
                        <td><span class="badge bg-danger">${est.total_faltas_injustificadas || 0}</span></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="progress flex-grow-1" style="height: 8px;">
                                    <div class="progress-bar bg-${colorBarra}" role="progressbar"
                                         style="width: ${porcentaje}%"></div>
                                </div>
                                <span class="ms-2 small fw-bold">${porcentaje}%</span>
                            </div>
                        </td>
                        <td>
                            <a href="reporte_individual.php?id=${est.id}" class="btn btn-sm btn-primary"
                               title="Ver reporte individual">
                                <i class="bi bi-file-earmark-text"></i>
                            </a>
                        </td>
                    </tr>
                `;
            }).join('');
        }

        async function exportarPDF() {
            if (!programacionSeleccionada) {
                alert('Primero debe generar un reporte seleccionando una sección');
                return;
            }

            if (!confirm('¿Desea generar el reporte PDF mensual?\n\nEste reporte mostrará una grilla con todos los días hábiles del periodo seleccionado.\n\nAsegúrese de haber seleccionado el rango de fechas correcto (máximo 1 mes recomendado).')) {
                return;
            }

            const fechaInicio = document.getElementById('fechaInicio').value;
            const fechaFin = document.getElementById('fechaFin').value;

            if (!fechaInicio || !fechaFin) {
                alert('Seleccione el rango de fechas');
                return;
            }

            // Mostrar loading
            document.body.style.cursor = 'wait';

            try {
                // Obtener datos para la grilla
                const response = await fetch(`ajax_reportes.php?accion=obtener_grilla_seccion&programacion_id=${programacionSeleccionada}&fecha_inicio=${fechaInicio}&fecha_fin=${fechaFin}`);
                const data = await response.json();

                if (!data.success) {
                    throw new Error(data.mensaje);
                }

                // Generar HTML de impresión
                generarHTMLGrilla(data.data);

                // Ocultar contenido normal
                document.querySelectorAll('.no-print').forEach(el => el.classList.add('d-none'));

                // Mostrar versión de impresión
                const printVersion = document.getElementById('printVersion');
                printVersion.classList.remove('d-none');
                printVersion.style.display = 'block';

                // Imprimir
                window.print();

            } catch (error) {
                console.error('Error:', error);
                alert('Error al generar el PDF: ' + error.message);
            } finally {
                document.body.style.cursor = 'default';

                // Restaurar después de imprimir
                setTimeout(() => {
                    const printVersion = document.getElementById('printVersion');
                    printVersion.classList.add('d-none');
                    printVersion.style.display = 'none';
                    document.querySelectorAll('.no-print').forEach(el => el.classList.remove('d-none'));
                }, 1000);
            }
        }

        function generarHTMLGrilla(data) {
            const container = document.getElementById('printVersion');
            const prog = data.programacion;
            const inst = data.institucion || {};
            const estudiantes = data.estudiantes;
            const fechas = data.fechas;
            const grilla = data.grilla;

            // Formatear fechas
            const fechaInicioFormatted = new Date(data.periodo.fecha_inicio + 'T00:00:00').toLocaleDateString('es-PE', { day: '2-digit', month: '2-digit', year: 'numeric' });
            const fechaFinFormatted = new Date(data.periodo.fecha_fin + 'T00:00:00').toLocaleDateString('es-PE', { day: '2-digit', month: '2-digit', year: 'numeric' });
            const fechaGeneracion = new Date().toLocaleDateString('es-PE', { day: '2-digit', month: '2-digit', year: 'numeric' }) + ' ' + new Date().toLocaleTimeString('es-PE', { hour: '2-digit', minute: '2-digit' });

            // Logo path
            const logoPath = inst.logo ? (inst.logo.startsWith('http') ? inst.logo : '/SICA/' + inst.logo) : '';

            // Generar encabezados de tabla con fechas (máximo 23 columnas)
            let encabezadosHTML = '<th class="celda-nro" style="width: 3%;">#</th>';
            encabezadosHTML += '<th class="celda-nombre">ESTUDIANTE</th>';
            encabezadosHTML += '<th class="celda-dni" style="width: 10%;">DNI</th>';

            // Array de iniciales de días de la semana
            const diasSemana = ['D', 'L', 'M', 'X', 'J', 'V', 'S'];

            fechas.slice(0, 23).forEach(fecha => {
                const [anio, mes, dia] = fecha.split('-');
                const fechaObj = new Date(fecha + 'T00:00:00');
                const diaSemanaIndex = fechaObj.getDay();
                const inicialDia = diasSemana[diaSemanaIndex];
                encabezadosHTML += `<th class="celda-fecha">${dia}/${mes}<br><small style="font-size: 5pt;">${inicialDia}</small></th>`;
            });

            // Rellenar hasta 23 columnas si hay menos fechas
            const columnasVacias = Math.max(0, 23 - fechas.length);
            for (let i = 0; i < columnasVacias; i++) {
                encabezadosHTML += '<th class="celda-fecha">-</th>';
            }

            // Generar filas de estudiantes
            let filasHTML = '';

            // Ordenar estudiantes alfabéticamente por apellidos y nombres
            const estudiantesOrdenados = estudiantes.sort((a, b) => {
                const nombreA = `${a.apellido_paterno} ${a.apellido_materno} ${a.nombres}`.toLowerCase();
                const nombreB = `${b.apellido_paterno} ${b.apellido_materno} ${b.nombres}`.toLowerCase();
                return nombreA.localeCompare(nombreB);
            });

            estudiantesOrdenados.forEach((est, index) => {
                filasHTML += '<tr>';

                // Número correlativo, Nombre y DNI
                filasHTML += `<td class="celda-nro" style="text-align: center; font-weight: bold;">${index + 1}</td>`;
                filasHTML += `<td class="celda-nombre">${est.apellido_paterno} ${est.apellido_materno} ${est.nombres}</td>`;
                filasHTML += `<td class="celda-dni">${est.dni}</td>`;

                // Celdas de asistencia (máximo 23)
                const asistencias = grilla[est.id] || {};

                fechas.slice(0, 23).forEach(fecha => {
                    const codigo = asistencias[fecha] || null;
                    let clase = 'codigo-vacio';
                    let texto = '-';

                    if (codigo) {
                        switch(codigo) {
                            case 'ASI':
                                clase = 'codigo-A';
                                texto = 'A';
                                break;
                            case 'TAR':
                                clase = 'codigo-T';
                                texto = 'T';
                                break;
                            case 'TJU':
                                clase = 'codigo-TJ';
                                texto = 'TJ';
                                break;
                            case 'FJU':
                                clase = 'codigo-FJ';
                                texto = 'FJ';
                                break;
                            case 'FIN':
                                clase = 'codigo-FI';
                                texto = 'FI';
                                break;
                        }
                    }

                    filasHTML += `<td class="celda-asistencia ${clase}">${texto}</td>`;
                });

                // Rellenar columnas vacías
                for (let i = 0; i < columnasVacias; i++) {
                    filasHTML += '<td class="celda-asistencia codigo-vacio">-</td>';
                }

                filasHTML += '</tr>';
            });

            container.innerHTML = `
                <div class="reporte-header">
                    ${logoPath ? `<div style="text-align: center; margin-bottom: 10px;"><img src="${logoPath}" alt="Logo" style="max-height: 50px; max-width: 150px;"></div>` : ''}
                    <h1 class="reporte-titulo">${inst.nombre || 'SICA'}</h1>
                    <p class="reporte-subtitulo">REPORTE MENSUAL DE ASISTENCIA POR SECCIÓN</p>
                    <div class="reporte-info">
                        <strong>Sección:</strong> ${prog.nivel} - ${prog.grado} "${prog.seccion}" (${prog.turno})<br>
                        <strong>Periodo:</strong> ${fechaInicioFormatted} a ${fechaFinFormatted}<br>
                        <strong>Fecha de generación:</strong> ${fechaGeneracion}
                    </div>
                </div>

                <table class="reporte-grilla">
                    <thead>
                        <tr>
                            ${encabezadosHTML}
                        </tr>
                    </thead>
                    <tbody>
                        ${filasHTML}
                    </tbody>
                </table>

                <div class="reporte-resumen">
                    <p style="margin: 1px 0; text-align: center;"><strong>TOTAL ESTUDIANTES:</strong> ${estudiantes.length}</p>
                </div>
            `;
        }
    </script>
</body>
</html>
